//
// C++ Implementation: kpgcast
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgcast.h"

// include files for KDE
#include <kiconloader.h>
#include <kdebug.h>

#include "kpgcastsfolder.h"
#include "../kpgsqlexception.h"

KPGCast::KPGCast(KPGCastsFolder *parent, const QString name, pqxx::oid _oid)
  : KPGObject(parent, name, _oid)
{
    setPixmap(0, *m_pIconCast);
}

KPGCast::KPGCast(KPGCastsFolder *parent, KPGCast *after, const QString name, pqxx::oid _oid)
  : KPGObject(parent, after, name, _oid)
{
    setPixmap(0, *m_pIconCast);
}

KPGCast::~KPGCast()
{
}

void KPGCast::setProperties(const pqxx::result::tuple &pqxxTuple)
{
    pqxxTuple["castsource"].to(m_oidSourceType);
    pqxxTuple["casttarget"].to(m_oidTargetType);
    pqxxTuple["castfunc"].to(m_oidCastFunc);
    pqxxTuple["pronamespace"].to(m_oidNameSpace);
            
	m_strContext = pqxxTuple["castcontext"].c_str();
	m_strSourceType = pqxxTuple["srctype"].c_str();
	m_strTargetType = pqxxTuple["trgtype"].c_str();
	m_strCastFunc = pqxxTuple["proname"].c_str();
	m_strNameSpace = pqxxTuple["nspname"].c_str();
}




