//                       -*- mode: C++ -*-
//
// Copyright(C) 2007 Stefan Siegl <stesie@brokenpipe.de>
//
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef SILCSTATUSFACTORY_H
#define SILCSTATUSFACTORY_H

#include <QHash>
#include <QString>

class SilcStatusFactory;
class SilcBuddyContact;
class SilcChannelContact;

namespace Kopete {
  class OnlineStatus;
}

class SilcStatusFactory {
protected:
  SilcStatusFactory();
  ~SilcStatusFactory();

public:
  static SilcStatusFactory *self(void);

  const Kopete::OnlineStatus &getBuddyOnlineStatus(SilcChannelContact *,
						   SilcBuddyContact *);

private:
  QHash<QString, Kopete::OnlineStatus *> _stats;
};


#endif
