/***************************************************************************
                          myktreelistitem.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include <kiconloader.h>
#include <qstringlist.h>
#include <klocale.h>
#include "myktreelistitem.h"

#include "komba2doc.h"
#include "komba2view.h"
/***************************************************************************
 *                                                                         *
 *   Class for Globalitem in Nettree-class														   *
 *                                                                         *
 ***************************************************************************/
MyNetworkItem::MyNetworkItem (Komba2Doc * thedoc, QListView * parent,
			      const QString & name):
QListViewItem (parent, name)
{
  doc = thedoc;
  setPixmap (0, SmallIcon ("samba"));
}

/***************************************************************************
 *                                                                         *
 *  add a new Share (if not allready exists) to Host								   		 *
 *  or update comment (if given)                                    			 *
 *                                                                         *
 ***************************************************************************/
MyShareItem *
MyNetworkItem::insertShare (const QString & workgroup,
			    const QString & hostname,
			    const QString & sharename,
			    MyShareItem::ShareTypes stype,
			    const QString theComment)
{
  MyWorkgroupItem *wg = getWorkgroup (workgroup);
  if (wg)
    return (wg->insertShare (hostname, sharename, stype, theComment));
  else
    return 0;
}

/***************************************************************************
 *                                                                         *
 *  add a new Host and Workgroup (if not allready exists) to Network   		 *
 *  or update (host) ip and comment (if given)                             *
 *                                                                         *
 ***************************************************************************/
MyHostItem *
MyNetworkItem::insertHost (const QString & workgroupname,
			   const QString & hostname, ulong theIP,
			   const QString theComment, const QString & os,
			   const QString & server)
{
  MyWorkgroupItem *wg = insertWorkgroup (workgroupname);
  return wg->insertHost (hostname, theIP, theComment, os, server);
}

/***************************************************************************
 *                                                                         *
 *  add a new Workgroup (if not allready exists) to Network					   		 *
 *                                                                         *
 ***************************************************************************/
MyWorkgroupItem *
MyNetworkItem::insertWorkgroup (const QString & workgroupname)
{
  MyWorkgroupItem *wg = getWorkgroup (workgroupname);

  if (!wg)
    {
      wg = new MyWorkgroupItem (this, workgroupname);
    }
  return wg;
}

/***************************************************************************
 *                                                                         *
 *  removes the WorkgroupItem from Network and delete the workgorupitem  	 *
 *                                                                         *
 ***************************************************************************/
void
MyNetworkItem::deleteWorkgroup (MyWorkgroupItem * oldworkgroup)
{
  if (oldworkgroup)
    {
      removeItem ((QListViewItem *) oldworkgroup);
      delete oldworkgroup;
    }
}

/***************************************************************************
 *                                                                         *
 *  return the WorkgroupItem, if not exists return 0									  	 *
 *                                                                         *
 ***************************************************************************/
MyWorkgroupItem *
MyNetworkItem::getWorkgroup (const QString & workgroupname)
{
  MyWorkgroupItem *wg = (MyWorkgroupItem *) firstChild ();
  while (wg)
    {
      if (workgroupname == wg->Name ())
	return wg;
      wg = (MyWorkgroupItem *) wg->nextSibling ();
    }
  return 0;
}

/***************************************************************************
 *                                                                         *
 *  return the HostItem, if not exists return 0												  	 *
 *                                                                         *
 ***************************************************************************/
MyHostItem *
MyNetworkItem::getHost (const QString & workgroupname,
			const QString & hostname)
{
  MyWorkgroupItem *wg = getWorkgroup (workgroupname);
  if (wg)
    return wg->getHost (hostname);
  else
    return 0;
}

/***************************************************************************
 *                                                                         *
 *  return the ShareItem, if not exists return 0												  	 *
 *                                                                         *
 ***************************************************************************/
MyShareItem *
MyNetworkItem::getShare (const QString & workgroupname,
			 const QString & hostname, const QString & sharename)
{
  MyWorkgroupItem *wg = getWorkgroup (workgroupname);
  if (wg)
    return wg->getShare (hostname, sharename);
  else
    return 0;
}

/***************************************************************************
 *                                                                         *
 *  return the ShareItem, if not exists return 0												  	 *
 *                                                                         *
 ***************************************************************************/
MyShareItem *
MyNetworkItem::getShare (const QString & hostname, const QString & sharename)
{
  MyShareItem *share = 0;
  MyWorkgroupItem *wg = (MyWorkgroupItem *) firstChild ();
  while (wg)
    {
      if ((share = getShare (wg->Name (), hostname, sharename)))
	return share;
      wg = (MyWorkgroupItem *) nextSibling ();
    }
  return 0;
}

void
MyNetworkItem::removeChilds ()
{
  QListViewItem *child;
  child = firstChild ();
  while (child)
    {
      getDocument ()->emitItemRemoved (child);
      ((MyWorkgroupItem *) child)->removeChilds ();
      takeItem (child);
      delete child;
      child = firstChild ();
    }
}

/*====================================================================================*/


/***************************************************************************
 *                                                                         *
 *   Class for Workgroupitem in Nettree-class														   *
 *                                                                         *
 ***************************************************************************/
MyWorkgroupItem::MyWorkgroupItem (QListViewItem * parent,
				  const QString & name):
QListViewItem (parent, name)
{
  master = 0;
  ask_for_password = true;
  setPixmap (0, SmallIcon ("network"));
  getDocument ()->setOptionsAccount ((QListViewItem *) this);
}

MyWorkgroupItem::~MyWorkgroupItem ()
{
}

/***************************************************************************
 *                                                                         *
 *  add a new Share (if not allready exists) to Host								   		 *
 *  or update comment (if given)                                    			 *
 *                                                                         *
 ***************************************************************************/
MyShareItem *
MyWorkgroupItem::insertShare (const QString & hostname,
			      const QString & sharename,
			      MyShareItem::ShareTypes stype,
			      const QString & theComment)
{
  MyHostItem *host = getHost (hostname);
  if (host)
    return (host->insertShare (sharename, stype, theComment));
  else
    return 0;
}


/***************************************************************************
 *                                                                         *
 *  add a new Host (if not allready exists) to Workgroup						   		 *
 *  or update ip and comment (if given)                                    *
 *                                                                         *
 ***************************************************************************/
MyHostItem *
MyWorkgroupItem::insertHost (const QString & hostname, ulong theIP,
			     const QString & theComment, const QString & os,
			     const QString & server)
{
  MyHostItem *host = getHost (hostname);

  if (!host)
    {
      host =
	new MyHostItem ((QListViewItem *) this, hostname, theIP, theComment,
			os, server);
      // set Domainpassword
    }
  else
    {
      if (theIP)
	host->setNetIP (theIP);
      if (!theComment.isEmpty ())
	host->setComment (theComment);
      if (!os.isEmpty ())
	host->setOS (os);
      if (!server.isEmpty ())
	host->setServer (server);
    }
  return host;
}

/***************************************************************************
 *                                                                         *
 *  removes the HostItem from Workgroup and delete the hostitemobject	   	 *
 *                                                                         *
 ***************************************************************************/
void
MyWorkgroupItem::deleteHost (MyHostItem * oldhost)
{
  if (oldhost)
    {
      removeItem ((QListViewItem *) oldhost);
      delete oldhost;
    }
}

/***************************************************************************
 *                                                                         *
 *  return the HostItem, if not exists return 0												  	 *
 *                                                                         *
 ***************************************************************************/
MyHostItem *
MyWorkgroupItem::getHost (const QString & hostname)
{
  MyHostItem *host = (MyHostItem *) firstChild ();
  while (host)
    {
      if (hostname == host->Name ())
	return host;
      host = (MyHostItem *) host->nextSibling ();
    }
  return 0;
}

/***************************************************************************
 *                                                                         *
 *  return the ShareItem, if not exists return 0												  	 *
 *                                                                         *
 ***************************************************************************/
MyShareItem *
MyWorkgroupItem::getShare (const QString & hostname,
			   const QString & sharename)
{
  MyHostItem *host = getHost (hostname);
  if (host)
    return host->getShare (sharename);
  else
    return 0;
}

	/***************************************************************************
	 *  is override to look first at the master														  	 *
	 ***************************************************************************/
void
MyWorkgroupItem::setOpen (bool o)
{
  QListViewItem::setOpen (o);
  if (o)
    if (getMaster ());
//                      ((Nettree*) listView())->scanHost(getMaster());
  QListViewItem::setOpen (o);
}

void
MyWorkgroupItem::setMaster (MyHostItem * m)
{
  master = m;
}

void
MyWorkgroupItem::removeChilds ()
{
  QListViewItem *child;
  child = firstChild ();
  while (child)
    {
      getDocument ()->emitItemRemoved (child);
      ((MyHostItem *) child)->removeChilds ();
      takeItem (child);
      delete child;
      child = firstChild ();
    }
}

/*====================================================================================*/


/***************************************************************************
 *                                                                         *
 *   Class for Hostitem in Nettree-class														   		 *
 *                                                                         *
 ***************************************************************************/


MyHostItem::MyHostItem (QListViewItem * parent, const QString & name,
			const ulong theip, const QString & theComment,
			const QString & theOs, const QString & theServer):
QListViewItem (parent, name)
{
  issearched (false);
  isdown = false;
  ask_for_password = true;
  ip = theip;
  setPixmap (0, SmallIcon ("host"));
  setName (name);
  username = QString::null;
  password = QString::null;
  os = theOs;
  server = theServer;
  comment = theComment;
  netnames = new QList < netbiosnames >;
  netnames->setAutoDelete (true);
  getDocument ()->setOptionsAccount ((QListViewItem *) this);
  getDocument ()->LookForIP (this);
}

MyHostItem::~MyHostItem ()
{
  netnames->clear ();
  delete netnames;
}

void
MyHostItem::appendNetName (const QString & name, const QString & service,
			   const QString & type, const QString & group)
{
  netbiosnames *n = new netbiosnames;
  n->name = name;
  n->service = service;
  n->type = type;
  n->group = group;
  netnames->append (n);
}

void
MyHostItem::setDown (bool s)
{
  if (s)
    setPixmap (0, SmallIcon ("host_down"));
  else
    setPixmap (0, SmallIcon ("host"));
  isdown = s;
}



QListViewItem *
MyHostItem::getNetName (QListView * list, netbiosnames * n)
{
  bool ok;
  QListViewItem *item = 0;
  if ((list) && (n))
    {
      item = new QListViewItem (list);
      item->setText (0, n->name);
      item->setText (1, n->service);
      item->setText (2, n->type);
      item->setText (3, n->group);
      switch (n->service.toInt (&ok, 16))
	{
	case 0:
	  if (n->name.contains ("IS~"))
	    item->setText (4, i18n ("Internet Information Server"));
	  else
	    item->setText (4, i18n ("Workstation Service"));
	  break;
	case 1:
	  if (n->name.contains ("_MSBROWSE_"))
	    item->setText (4, i18n ("Master Browser"));
	  else
	    item->setText (4, i18n ("Messenger Service"));
	  break;
	case 3:
	  item->setText (4, i18n ("Messenger Service"));
	  break;
	case 6:
	  item->setText (4, i18n ("RAS Server Service"));
	  break;
	case 0x1f:
	  item->setText (4, i18n ("NetDDE Service"));
	  break;
	case 0x20:
	  if (n->name == "Forte_$ND800ZA")
	    item->setText (4, i18n ("DCA Irmalan Gateway Service"));
	  else
	    item->setText (4, i18n ("File Server Service"));
	  break;
	case 0x21:
	  item->setText (4, i18n ("RAS Client Service"));
	  break;
	case 0x22:
	  item->setText (4, i18n ("Exchange Interchange"));
	  break;
	case 0x23:
	  item->setText (4, i18n ("Exchange Store"));
	  break;
	case 0x24:
	  item->setText (4, i18n ("Exchange Directory"));
	  break;
	case 0x30:
	  item->setText (4, i18n ("Modem Sharing Server Service"));
	  break;
	case 0x31:
	  item->setText (4, i18n ("Modem Sharing Client Service"));
	  break;
	case 0x43:
	  item->setText (4, i18n ("SMS Client Remote Control"));
	  break;
	case 0x44:
	  item->setText (4, i18n ("SMS Admin Remote Control"));
	  break;
	case 0x45:
	  item->setText (4, i18n ("SMS Client Remote Chat"));
	  break;
	case 0x46:
	  item->setText (4, i18n ("SMS Client Remote Transfer"));
	  break;
	case 0x4C:
	  item->setText (4, i18n ("DEC Pathworks TCP/IP Service"));
	  break;
	case 0x52:
	  item->setText (4, i18n ("DEC Pathworks TCP/IP Service"));
	  break;
	case 0x87:
	  item->setText (4, i18n ("Exchange MTA"));
	  break;
	case 0x6A:
	  item->setText (4, i18n ("Exchange IMC"));
	  break;
	case 0xBE:
	  item->setText (4, i18n ("Network Monitor Agent"));
	  break;
	case 0xBF:
	  item->setText (4, i18n ("Network Monitor Apps"));
	  break;
	case 0x1B:
	  item->setText (4, i18n ("Domain Master Browser"));
	  break;
	case 0x1C:
	  if (n->name.contains ("INET~SERVICES"))
	    item->setText (4, i18n ("Internet Information Server"));
	  else
	    item->setText (4, i18n ("Domain Controllers"));
	  break;
	case 0x1D:
	  item->setText (4, i18n ("Master Browser"));
	  break;
	case 0x2F:
	  item->setText (4, i18n ("Lotus Notes"));
	  break;
	case 0x33:
	  item->setText (4, i18n ("Lotus Notes"));
	  break;
	case 0x2B:
	  item->setText (4, i18n ("Lotus Notes Server"));
	  break;
	case 0x1E:
	  item->setText (4, i18n ("Browser Service Elections"));
	  break;
	default:
	  item->setText (4, i18n ("Unknown"));
	  break;
	}
    }
  return item;
}

QListViewItem *
MyHostItem::nextNetName (QListView * list)
{
  return getNetName (list, netnames->next ());
};

void
MyHostItem::removeChilds ()
{
  QListViewItem *child;
  child = firstChild ();
  while (child)
    {
      getDocument ()->emitItemRemoved (child);
      takeItem (child);
      delete child;
      child = firstChild ();
    }
}

bool MyHostItem::searchNetNames (QRegExp & tofind)
{
  netbiosnames *
    n =
    netnames->
    first ();
  while (n)
    {
      if (n->name.find (tofind) == 0)
	return true;
      n = netnames->next ();
    }
  return false;
}

QStringList *
MyHostItem::getNetNames (QStringList * list, bool onlyMessageNames)
{
  netbiosnames *n = netnames->first ();
  while (n)
    {
      // only Messageserices ?
      if (onlyMessageNames)
	{
	  if (((n->service == "03") || (n->service == "01"))
	      && (!n->name.contains ("_MSBROWSE_")))
	    list->append (n->name);
	}
      else
	list->append (n->name);
      n = netnames->next ();
    }
  return list;
}

void
MyHostItem::setComment (const QString & the_comment)
{
  comment = the_comment;
  setText (2, comment);
};


void
MyHostItem::setNetIP (ulong hostip)
{
  QString s;
  ip = hostip;
  getIP (&s);
  setText (1, s);
};

void
MyHostItem::setAccount (QString name, QString pw)
{
  setPassword (pw);
  setUsername (name);
}

/***************************************************************************
 *                                                                         *
 *  Return the IP as ASCII String (192.168.0.0)											   		 *
 *                                                                         *
 ***************************************************************************/
void
MyHostItem::getIP (QString * ipp)
{
  QString s;
  *ipp = s.setNum ((uint) (uchar) (ip >> 24));
  *ipp += ".";
  *ipp += s.setNum ((uint) (uchar) (ip >> 16));
  *ipp += ".";
  *ipp += s.setNum ((uint) (uchar) (ip >> 8));
  *ipp += ".";
  *ipp += s.setNum ((uint) (uchar) ip);
}

/***************************************************************************
 *                                                                         *
 *  add a new Share (if not allready exists) to Host								   		 *
 *  or update comment (if given)                                    			 *
 *                                                                         *
 ***************************************************************************/
MyShareItem *
MyHostItem::insertShare (const QString & sharename,
			 MyShareItem::ShareTypes stype,
			 const QString & theComment)
{
  MyShareItem *share = getShare (sharename);

  if (!share)
    {
      share = new MyShareItem (this, sharename);
      share->setSharetype (stype);
      share->setComment (theComment);
    }
  else
    {
      if (theComment)
	share->setComment (theComment);
    }
  return share;
}


/***************************************************************************
 *                                                                         *
 *  removes the Shareitem from Host and delete the shareitemobject	   		 *
 *                                                                         *
 ***************************************************************************/
void
MyHostItem::deleteShare (MyShareItem * oldshare)
{
  if (oldshare)
    {
      removeItem ((QListViewItem *) oldshare);
      delete oldshare;
    }
}


/***************************************************************************
 *                                                                         *
 *   returns the name of the Workgroup of the Host									   		 *
 *                                                                         *
 ***************************************************************************/
const QString
MyHostItem::getWorkgroupName ()
{
  if (parent ())
    return ((MyWorkgroupItem *) parent ())->Name ();
  else
    return 0;
}

QString & MyHostItem::getUsername ()
{
  if ((password.length () > 0) || (username.length () > 0))
    return username;
  else
    return ((MyWorkgroupItem *) parent ())->getUsername ();
}

QString & MyHostItem::getPassword ()
{
  if ((password.length () > 0) || (username.length () > 0))
    return password;
  else
    return ((MyWorkgroupItem *) parent ())->getPassword ();
}

/***************************************************************************
 *                                                                         *
 *  return the ShareItem, if not exists return 0											  	 *
 *                                                                         *
 ***************************************************************************/
MyShareItem *
MyHostItem::getShare (const QString & sharename)
{
  MyShareItem *share = (MyShareItem *) firstChild ();
  while (share)
    {
      if (sharename == share->Name ())
	return share;
      share = (MyShareItem *) share->nextSibling ();
    }
  return 0;
}

/***************************************************************************
 *  is override to look first for shares															  	 *
 ***************************************************************************/
void
MyHostItem::setOpen (bool o)
{
  if (o);
//              ((Nettree*) listView())->scanHost(this);
  QListViewItem::setOpen (o);
}


/*====================================================================================*/

/***************************************************************************
 *                                                                         *
 *   Class for Shareitem in Nettree-class														   		 *
 *                                                                         *
 ***************************************************************************/
MyShareItem::MyShareItem (QListViewItem * parent, const QString & name):
QListViewItem (parent, name)
{
  ask_for_password = true;
  isautomount = false;
  mount_path = QString::null;
  username = QString::null;
  password = QString::null;
  getDocument ()->setOptionsAccount ((QListViewItem *) this);
}

MyShareItem::~MyShareItem ()
{
}

/***************************************************************************
 *                                                                         *
 *   returns the name of the host of the share											   		 *
 *                                                                         *
 ***************************************************************************/
const QString
MyShareItem::getHostName ()
{
  if (parent ())
    return ((MyHostItem *) parent ())->Name ();
  return 0;
}

const QString
MyShareItem::getWorkgroupName ()
{
  if (parent ())
    if (parent ()->parent ())
      return ((MyWorkgroupItem *) parent ()->parent ())->Name ();
  return 0;
}

void
MyShareItem::setComment (const QString & sharecomment)
{
  comment = sharecomment;
  setText (2, sharecomment);
};

void
MyShareItem::setSharetype (ShareTypes sharetype)
{

  share_type = sharetype;
  switch (share_type)
    {
    case Disk:
      if (getMountPath ().length () == 0)
	setPixmap (0, SmallIcon ("folder"));
      else
	setPixmap (0, SmallIcon ("folder_open"));
      break;
    case Printer:
      setPixmap (0, SmallIcon ("printer1"));
      break;
    case IPC:
      setPixmap (0, SmallIcon ("blockdevice"));
      break;
    case unknown:
      setPixmap (0, SmallIcon ("help"));
      break;
    }
}

void
MyShareItem::setAccount (QString name, QString pw)
{
  setPassword (pw);
  setUsername (name);
}

QString & MyShareItem::getUsername ()
{
  if ((password.length () > 0) || (username.length () > 0))
    return username;
  return ((MyHostItem *) parent ())->getUsername ();
}

QString & MyShareItem::getPassword ()
{
  if ((password.length () > 0) || (username.length () > 0))
    return password;
  return ((MyHostItem *) parent ())->getPassword ();
}


void
MyShareItem::setMountPath (const QString & mountpath)
{
  mount_path = mountpath;
  if (getSharetype () == Disk)
    {
      if (mount_path.length () == 0)
	setPixmap (0, SmallIcon ("folder"));
      else
	setPixmap (0, SmallIcon ("folder_open"));
    }
}

Komba2Doc *
MyShareItem::getDocument ()
{
  return ((MyHostItem *) parent ())->getDocument ();
}

/***************************************************************************
 *   unmount this share if it is mounted														   		 *
 ***************************************************************************/
void
MyShareItem::unmount ()
{
  getDocument ()->Shareumount (this);
}

/***************************************************************************
 *   mount this share to a specefied path														   		 *
 ***************************************************************************/
void
MyShareItem::mount (QString dir)
{
  getDocument ()->Sharemount (this, true, dir);
}

/*====================================================================================*/

/***************************************************************************
 *                                                                         *
 *   Class for copy Workgroup-, Host- and Shareitem 								   		 *
 *                                                                         *
 ***************************************************************************/
MyCopyItem::MyCopyItem (QListView * parent, MyShareItem * item):QListViewItem (parent,
	       item->
	       Name ())
{
  origitem = (QListViewItem *) item;
  setPixmap (0, *(item->pixmap (0)));
}

MyCopyItem::MyCopyItem (QListView * parent, MyHostItem * item):QListViewItem (parent,
	       item->
	       Name ())
{
  origitem = (QListViewItem *) item;
  setText (1, item->text (1));
  setPixmap (0, *(item->pixmap (0)));
}

MyCopyItem::MyCopyItem (QListView * parent, MyWorkgroupItem * item):QListViewItem (parent,
	       item->
	       Name ())
{
  origitem = (QListViewItem *) item;
  setPixmap (0, *(item->pixmap (0)));
}



/** returns the orignal Item of the copyitem */
QListViewItem *
MyCopyItem::getCopyItem ()
{
  return origitem;
}

/**  */
void
MyWorkgroupItem::setAccount (QString name, QString pw)
{
  MyHostItem *host;
  MyShareItem *share;
  setUsername (name);
  setPassword (pw);
  host = (MyHostItem *) firstChild ();
  while (host)
    {
      host->setUsername (name);
      host->setPassword (pw);
      share = (MyShareItem *) host->firstChild ();
      while (share)
	{
	  share->setUsername (name);
	  share->setPassword (pw);
	  share = (MyShareItem *) share->nextSibling ();
	}
      host = (MyHostItem *) host->nextSibling ();
    }
}
