//
// C++ Implementation: kmfiptdocview
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfiptdocview.h"

// QT includes


// KDE includes
#include <kdebug.h>

// Project includes
#include "../core/kmfiptdoc.h"
#include "../core/kmfdoc.h"
#include "../core/iptable.h"
#include "../core/xmlnames.h"
namespace KMF {
KMFIPTDocView::KMFIPTDocView(QWidget *parent, const char *name) : QTabWidget(parent, name)
{
	loaded = false;
	m_iptViewFilter = new KMFListView( 0, "view" );
	m_iptViewNat = new KMFListView( 0, "view" );
	m_iptViewMangle = new KMFListView( 0, "view" );
	addTab( m_iptViewFilter, "Filter" );
	addTab( m_iptViewNat, "Nat" );
	addTab( m_iptViewMangle, "Mangle" );

	m_iptViewFilter ->setEnabled( true );
	m_iptViewFilter->clear();
	m_iptViewFilter->slotUpdateView();
	
	m_iptViewNat ->setEnabled( true );
	m_iptViewNat->clear();
	m_iptViewNat->slotUpdateView();
	
	m_iptViewMangle ->setEnabled( true );
	m_iptViewMangle->clear();
	m_iptViewMangle->slotUpdateView();

	setMinimumSize( 600, 400 );
}


KMFIPTDocView::~KMFIPTDocView()
{
}

void KMFIPTDocView::slotLoadDoc( KMFIPTDoc  *iptdoc ) {
	kdDebug() << "void KMFIPTDocView::slotLoadDoc( KMFIPTDoc  *iptdoc )" << endl;
	if ( ! loaded ) {
		m_iptViewMangle->clear();
		m_iptViewFilter->slotLoadNode( iptdoc->table( Constants::FilterTable_Name ) );
		m_iptViewFilter->slotUpdateView();
		m_iptViewMangle->clear();
		m_iptViewNat->slotLoadNode( iptdoc->table( Constants::NatTable_Name ) );
		m_iptViewFilter->slotUpdateView();
		m_iptViewMangle->clear();
		m_iptViewMangle->slotLoadNode( iptdoc->table( Constants::MangleTable_Name ) );
		m_iptViewFilter->slotUpdateView();
		loaded = true;
	} else {
		
		m_iptViewFilter->slotUpdateView( iptdoc->table( Constants::FilterTable_Name ) );	
		m_iptViewFilter->slotUpdateView();
		
		m_iptViewNat->slotUpdateView( iptdoc->table( Constants::NatTable_Name ) );	
		m_iptViewNat->slotUpdateView();
		
		m_iptViewMangle->slotUpdateView( iptdoc->table( Constants::MangleTable_Name ) );	
		m_iptViewMangle->slotUpdateView();
	}
}

void KMFIPTDocView::slotLoadTable( IPTable* ) {

}

void KMFIPTDocView::close() {
	kdDebug() << "void KMFIPTDocView::close()" << endl;
	emit closing();
	QTabWidget::close();
}

void KMFIPTDocView::show() {
	kdDebug() << "void KMFIPTDocView::show()" << endl;
	emit showing();
	QTabWidget::show();
	m_iptViewFilter->slotUpdateView();
	m_iptViewNat->slotUpdateView();	
	m_iptViewMangle->slotUpdateView();
}

void KMFIPTDocView::hide() {
	kdDebug() << "void KMFIPTDocView::hide()" << endl;
	emit closing();
	QTabWidget::hide();
}


}

#include "kmfiptdocview.moc"
