//
//
// C++ Interface: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICINTERFACEPROTOCOL_H
#define KMFGENERICINTERFACEPROTOCOL_H

#include <kmyfirewallgenericinterfaceprotocolwidget.h>

// QT includes
class QListViewItem;


#include <qptrlist.h>
#include <qstring.h>
#include <qguardedptr.h>
#include <qpixmap.h>
#include <quuid.h>

// KDE includes
class KPopupMenu;

// Project includes
#include "../core/kmfprotocol.h"
#include "../core/kmfprotocolusage.h"
#include "../core/kmfprotocolcategory.h"


class QCheckBox;
class QTextEdit;

/*class KMFErrorHandler;*/

namespace KMF {
class KMFNetwork;
class KMFGenericDoc;
class KMFNetZone;
class KMFListViewItem;
class KMFNetHost;
class KMFNetworkWidget;
class KMFNetHostPropertiesWidget;
class KMFProtocolPropertiesWidget;
class KMFProtocolListView;

class KMFGenericInterfaceProtocol : public KMyFirewallGenericInterfaceProtocolWidget {
	Q_OBJECT
public:
	KMFGenericInterfaceProtocol( QWidget *parent = 0, const char *name = 0, WFlags f = 0 );

	~KMFGenericInterfaceProtocol();
	void loadDoc( KMFNetwork* );

// 	void setType( int );
// 	enum { INCOMING, OUTGOING };

public slots:
	void slotUpdateView();
	void slotUpdateView( NetfilterObject* );

private slots:
// 	void slotNewProtocolSelected( QListViewItem* );
	void slotNewItemSelected( QListViewItem* );
	void slotZoneRBM( QListViewItem*, const QPoint&, int );
	void slotAddZone();
	void slotDelZone();
	void slotAddHost();
	void slotDelHost();
	void slotAddressChanged( const QString& );
	void slotZoneChanged( KMFNetZone* );
	void slotCurrentZoneChanged( const QString& );
	void slotRenameZone();
	void slotRenameHost();
	void slotRenameItem( QListViewItem* item, int, const QString& name );
	void slotRestrictionChanged();
	void slotProtocolClicked( KMFProtocolUsage*, bool );
	void slotProtocolCategoryClicked( KMFProtocolCategory* );
private:
	void loadIcons();
 	KMFListViewItem* findItem( const QUuid& obj_id );

private:
	QGuardedPtr<KMFNetwork> m_doc;
	
	KPopupMenu* m_contextMenu;

	KMFNetworkWidget *m_network_widget;
	KMFNetHostPropertiesWidget *m_nethostProperties_widget;
	KMFProtocolPropertiesWidget *m_protocolProperties_widget;
	KMFProtocolListView *m_protocolLIstView;
	
	QPtrList<KMFNetZone> m_zones;
	QGuardedPtr<KMFProtocolUsage> m_protocolUsage;
	QGuardedPtr<KMFNetZone> m_zone;
	QGuardedPtr<KMFNetHost> m_host;
	
	int m_type;
	QPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
	icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
	        icon_target, icon_queue, icon_new, icon_copy, icon_move;

};
}
#endif
