//
// C++ Interface: kmfprotocolusage
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFPROTOCOLUSAGE_H
#define KMFPROTOCOLUSAGE_H

#include "netfilterobject.h"

// QT includes
#include <qstringlist.h>
#include <qstring.h>
#include <qguardedptr.h>
#include <qptrlist.h>
#include <qmap.h>
#include <qobject.h>
// KDE includes
#include <kdemacros.h>
#include <kurl.h>

// Project includes
#include "kmfprotocol.h"

namespace KMF {
/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/

class KMFProtocolUsage : public NetfilterObject {
	friend class KMFProtocol;
Q_OBJECT
public:
	
    ~KMFProtocolUsage();
    
    void setProtocol( KMFProtocol* );
    KMFProtocol *protocol() const {
    	return m_protocol;
    }
    
    virtual int type();
    virtual void clear();
    
    virtual const QString& name();
    virtual const QString& description();
    
    bool validUsage();
    
    void setLimitInterval( const QString& );
	void setLimit( int );
	
	int limit() const {
		return m_limit;
	};

	const QString& limitInterval() const {
		return m_limit_interval;
	};
	
	void setLogging( bool );
    bool logging() const {
		return m_log;
	};
	
	enum { OUTGOING, INCOMING } IO;
	void setIO ( int );
	int io() const {
		return m_io;
	};
	
	const QDomDocument& getDOMTree();
	virtual void loadXML(const QDomDocument&, QStringList& errors );
	virtual void loadXML( QDomNode, QStringList& errors );

public slots:
	void slotOnProtocolDeleted( QObject* protocol );

private: 
	KMFProtocolUsage( NetfilterObject* parent, const char* name );
	QGuardedPtr<KMFProtocol> m_protocol;
	QString m_limit_interval;
	int m_limit;
	int m_protocolType, m_io;
	bool m_log;
};
}
#endif
