//
// C++ Interface: kmfpluginfactory
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
// License: GPL
//
#ifndef KMFPLUGINFACTORY_H
#define KMFPLUGINFACTORY_H

/**
@author Christian Hubinger
*/
// QT includes
#include <qstring.h>
#include <qptrlist.h>
#include <qvaluelist.h>
// KDE includes
// #include <kparts>
#include <kparts/part.h>
#include <kparts/mainwindow.h>

class QObject;
namespace KMF {
class KMFTarget;
class KMFError;
class KMFCompilerInterface;
class KMFInstallerInterface;
class KMFRuleOptionEditInterface;
class KMFRuleTargetOptionEditInterface;


class KDE_EXPORT KMFPluginFactory {
	friend class KMFTarget;
private:
	KMFPluginFactory();
	~KMFPluginFactory();
public:
static QPtrList<KMFRuleOptionEditInterface>* KMFRuleOptionEditors(  QObject *parent );

static QPtrList<KMFRuleTargetOptionEditInterface>* KMFRuleTargetOptionEditors( QObject *parent );
static QValueList<KMFCompilerInterface*>* CompilersForInstaller( const QString& osName  );

static KParts::ReadWritePart* KMFMainView( KParts::MainWindow* parent, KMFError* err );

private:
static KMFCompilerInterface* KMFCompiler( KMFTarget* ); 
static KMFInstallerInterface* KMFInstaller( KMFTarget* ); 


};
}
#endif
