/***************************************************************************
 begin                : Tue Aug 6 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFERROR_H
#define KMFERROR_H

#include <qstring.h> 
#include <kdemacros.h>
#include <qstringlist.h>

/**
  *@author Christian Hubinger
  */
using namespace std;
namespace KMF {
class KDE_EXPORT KMFError {

// using namespace  ;


public:
/** Contains the option commands for each option type. */
	static KMFError* parseErrors( QStringList& errors );
	static const QString& getAsString( int error_type, const QString& msg );

public:
	KMFError();
	~KMFError();

	enum {  OK = 0, HINT = 1, NORMAL = 2, FATAL = 3, WARNING = 4 };
	
	/** Set the error message */
	void setErrMsg( const QString& msg );
	
	/** Sets the message type */
	void setErrType( int type );

	/** get the Error message */
	const QString& errMsg() const {
		return m_err_msg;
	};

	/** Get the error number */
	int errNum() const {
		return m_err_num;
	};

	/** Get the error type e.g. HINT, FATAL etc.*/
	int errType() const {
		return m_err_type;
	};

private:
	int m_err_type;
	QString m_err_msg;
	int m_err_num;
};
}
#endif
