/***************************************************************************
begin                : Mon Jan 28 2002
copyright            : (C) 2002 by Christian Hubinger
email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KMFDOC_H
#define KMFDOC_H

//project includes
#include "iptchain.h"
#include "iptrule.h"
#include "iptruleoption.h"
#include "iptable.h"
#include "kmfnetzone.h"
#include "netfilterobject.h"

// qt includes
#include "qdict.h"
#include "qvaluelist.h"
#include "qptrlist.h"
#include "qstring.h"
#include "qobject.h"

// kde includes
#include "kurl.h"

/**
  *@author Christian Hubinger
  */
class KURL;

namespace KMF {
class KMFErrorHandler;
class KMFError;

class KMFNetwork;
class KMFTarget;

//############# Start class KMFDoc ###############
/**
	KMFDoc is the base class for all document classes in KMyFirewall.
	It provides the most common features a document class should have
	e.g. undo/redo setUrl() setFilename() etc. and lots of abstarct methods
	that need to be implemented by a document class.
*/

class KDE_EXPORT KMFDoc : public NetfilterObject {
	Q_OBJECT
public:
	KMFDoc( NetfilterObject* parent, const char* name );
	virtual ~KMFDoc();


	/** resets the document to the initial values */
	virtual void clear() = 0;

//	/** return a QString containing the documents script to 
//		setup the firewall configuration */
//	virtual const QString& compile() = 0;
	
	/** Writes the xml-representation of this document a String and returns it. */
	virtual const QString& getXMLRuleset();

	/** return true if the document is in it's initial state */
	virtual bool isEmpty() = 0;

//	/** Writes the shellscrip that contains the iptables commands to settup
//		the firewall to file.
//		If file = QString::null a SaveAs dialog will popup. */
//	KMFError* createFirewallScript( const QString& fi );

//	/** Return DomDocument of this Chain */
// 	virtual const QDomDocument& getDOMTree() = 0;

	/** Return String representation of the DomDocument generated by const QDomDocument& getDOMTree() */
	virtual const QString& getXMLSniplet();

	/** Load configuratuion from the QDomDocument */
//  	virtual void loadXML( const QDomDocument&, QStringList& errors ) = 0;
	
	/** Load configuratuion from the QDomDocument */
//  	virtual void loadXML( QDomNode, QStringList& errors ) = 0;

	/** Save the rule set to the given file defined by the KURL */
	virtual KMFError* exportXMLRuleset( bool promptFile, bool asTemplate );
		
	/** Get the File dialog filter string for the document type */	
	virtual const QString& getFileDialogFilter() = 0;

	/** Load the ruleset from the given url */
	virtual void parseDocument( const KURL&, QStringList& errors ) = 0;
	
	/** return the documents KURL pointer */
	KURL& url();
	
	bool newSavePathNeeded();
	void resetUrl();
	
	/** Set Description for this Object */
// 	virtual void setDescription( const QString& ) = 0;
	
	/** Return the Object's Description */
/*	const QString description() const {
		return m_description;
	};*/
	
	/** Set Name for this Object */
// 	virtual void setName( const QString& ) = 0;
	
	/** Return the Object's Description */
	virtual const QString& docName();
	
	
	// void objChanged();
// 	void objChanged( int );
	
	/** update the View */
	void updateView();
	
protected:
	virtual KMFError* exportXMLRuleset( const KURL& );	
	virtual void initDoc() = 0;

	KURL m_url;
	KMFErrorHandler *m_err_handler;
	KMFError *m_err;
	bool m_newSavePathNeeded;
	
signals:
	void documentChanged();
	void documentChanged( KMFDoc* );
	void sigEnableUndo( bool );
	void sigEnableRedo( bool );

};
}




#endif
