//
// C++ Interface: kmfpfcompiler
//
// Description:
//
//
// Author: Christian Hubinger <e9806056@student.tuwien.ac.at>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFPFCOMPILER_H
#define KMFPFCOMPILER_H

#include "../../core/kmfcompilerinterface.h"

/**
@author Christian Hubinger
*/

// QT includes
#include <qstring.h>
#include <qobject.h>
#include <qvaluelist.h>

// KDE includes
#include <kparts/part.h>
#include <kparts/plugin.h>
#include <kparts/factory.h>
#include <kxmlgui.h>

// Project includes
#include "../../core/kmfplugin.h"
#include "../../core/kmfcompilerinterface.h"


class KInstance;
namespace KMF {
class KMFGenericDoc;
class KMFIPTDoc;
class KMFNetZone;
class IPTChain;



class KMFPFCompiler :  public KMFPlugin, public virtual KMFCompilerInterface {
	Q_OBJECT
public:
	KMFPFCompiler( QObject* parent, const char* name );
	~KMFPFCompiler();
	void compile();
	const QString& compile( KMFGenericDoc* );
	const QString& osName();
	const QString& osGUIName();
	const QString& backendName();
	const QString& backendGUIName();

private:
	void setupInAndOutHosts( KMFNetZone*,  const QString& );
	void setupForbiddenHosts( KMFNetZone*, const QString&  );
	void setupICMPRules( KMFGenericDoc* );
	void setupLocalhostRules();
	void setupPolicies( KMFGenericDoc* );
	void setupNatRules( KMFGenericDoc* );
	void createIncommingACCESSRules( KMFNetZone*, KMFGenericDoc* );
	void createOutgoingACCESSRules( KMFNetZone*, KMFGenericDoc* );
	
	QString getPortList( QValueList<int>& );
	
	
// 	void addToChains( KMFNetZone*, KMFIPTDoc* , IPTChain*, const QString& );
// 	void createRules( KMFNetZone*, IPTChain*, const QString& );
// 	void setupLocalhostRules(  KMFGenericDoc*, KMFIPTDoc* );
// 	void setupConnectionTracking( KMFIPTDoc* );
// 	void setupPolicies( KMFGenericDoc*, KMFIPTDoc* );
// 	void createZoneProtocolRules( IPTChain*, KMFProtocolUsage* );
// 	void createZoneProtocol( IPTChain*, KMFProtocolUsage* prot , const QString& option, const QString& ports );
// 	void createHostProtocolRules( IPTChain*, KMFNetHost*, KMFProtocolUsage*, const QString& );
// 	void createHostProtocol( IPTChain*, KMFNetHost*, KMFProtocolUsage* prot , const QString& option, const QString&, const QString& );
// 	
// 	void setupForbiddenHosts( KMFIPTDoc*, KMFNetZone*, const QString&  );
// 	
// 	void setupICMPRules( KMFGenericDoc*, KMFIPTDoc* );
// 	
// 	void setupNatRules( KMFGenericDoc*, KMFIPTDoc* );
// 	void setupNatTarget( KMFGenericDoc*, IPTRule* );
// 	void setupLogging( KMFGenericDoc*, KMFIPTDoc* );
// 	void setupLoggingRules( KMFGenericDoc*, IPTChain* );


private:
	KMFGenericDoc *m_doc;
	QString m_compiledScript;
	
	QString m_osName;
	QString m_osGUIName;
	QString m_backendName;
	QString m_backendGUIName;


private slots:
	void slotExportPF();
	
	
	
	
	
// 	void slotShowPFScript();
};





class KMFPFCompilerFactory : public KLibFactory {
	Q_OBJECT
public:
	KMFPFCompilerFactory( QObject *parent = 0, const char *name = 0 );
	virtual ~KMFPFCompilerFactory() {
/* 		delete s_instance; */
	};
	virtual QObject* createObject( QObject* parent = 0, const char* pname = 0,
	                               const char* name = "QObject",
	                               const QStringList &args = QStringList() );
	/*     static KInstance* instance(); */

/*private:
	static KInstance* s_instance;*/
};
}


#endif
