/***************************************************************************
 *   Copyright (C) 2004 by Marco Gulino                                    *
 *   marco.gulino@gmail.com                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "c_smslist.h"
#include <kdebug.h>

c_SMSList::c_SMSList()
 : QPtrList<c_SMS>()
{
	setAutoDelete(true);
	countNewSMS=0;
}

QStringList c_SMSList::parseSMSListID(QString buffer,const char* memSlot, const char* sep)
{
	QStringList idList;
	for( int i=1; i<=buffer.contains(sep) ;i++ ){
		idList += (QString(memSlot) + "-%1").arg(buffer.section(sep, i, i).section(',', 0, 0).stripWhiteSpace().toInt(), 3);
	}
	return idList;
}

c_SMS* c_SMSList::find(QString sms_ID)
{
    QPtrListIterator<c_SMS> it( *this );
	if (it.isEmpty() ) return NULL;
	it.toFirst();
    c_SMS *curSMS;
    while ( (curSMS = it.current()) != 0 ) {
		if(curSMS->id() == sms_ID && curSMS!=NULL) return curSMS;
        ++it;
    }
    return NULL;
}
c_SMS* c_SMSList::find(QStringList numbers, QStringList texts)
{
    QPtrListIterator<c_SMS> it( *this );
	if (it.isEmpty() ) return NULL;
	it.toFirst();
    c_SMS *curSMS;
    while ( (curSMS = it.current()) != 0 ) {
		if(curSMS->Numbers().join("\n") == numbers.join("\n") && curSMS->TextList().join("\n")==texts.join("\n") ) 
			return curSMS;
        ++it;
    }
    return NULL;
}

QString c_SMSList::toString( QString separator )
{
    QPtrListIterator<c_SMS> it( *this );
	QString out;
	if (it.isEmpty() ) return NULL;
	it.toFirst();
    c_SMS *curSMS;
    while ( (curSMS = it.current()) != 0 ) {
		out+= curSMS->toString() + separator;
        ++it;
    }
    return out;
}
