/***************************************************************************
                          mimeapplication.h -  description
                             -------------------
    begin                : Thu Nov 23 2004
    copyright            : (C) 2003 by Mike K. Bennett
                           (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIMEAPPLICATION_H
#define MIMEAPPLICATION_H

#include "application.h"



/**
 * The base class for all old-style (pre-msn6) invitations.
 * These invitations use plain text MIME messages to exchange the invitation data.
 * The incoming messages are passed to the gotMessage() method.
 * This method automatically calls the correct <code>contactStarted*</code>
 * and <code>userStarted*</code> methods.
 * These methods are implemented in each one of the derived classes.
 *
 * @author Mike K. Bennett, Diederik van der Boor
 * @ingroup Applications
 */
class MimeApplication : public Application
{
  Q_OBJECT

  public:
    // The constructor
                           MimeApplication(const QString &contactHandle);
    // The descructor
    virtual               ~MimeApplication();

    // The contact aborted the session
    virtual void           contactAborted( const QString &message = QString() );
    // Parse a received message (implements a pure virtual method)
    void                   gotMessage(const MimeMessage& message);
    // The user aborted the application
    virtual void           userAborted();

  protected:
    // Return the session ID, generating one if it doesn't exist
    const QString&         getSessionId();
    // Send a cancel message and terminate the application (implements a pure virtual method).
    void                   sendCancelMessage(const ApplicationCancelReason cancelReason);
    // Send a message to the contact
    void                   sendMessage(const MimeMessage& message);
    // The user rejected (declined) the application
    virtual void           userRejected();

  private: // Private methods
    // Generate a random session ID
    QString                generateSessionId() const;

  private: // Private attributes
    // A session ID
    QString                sessionId_;

  signals:
    // Give the ApplicationList a message to send to the server.
    void                   putMsg(const MimeApplication *source, const MimeMessage &message);
};

#endif
