#ifndef SIMPLE_DEVICE_CLASS
#define SIMPLE_DEVICE_CLASS

#include <qpainter.h>
#include "xdevice.h"

// simple device with same operation for all input and common output
class SimpleDevice : public XDevice
{
public:
	SimpleDevice(int iFunction, const QPoint& oPos, int iSize = -1);
	virtual ~SimpleDevice();

	virtual void init();

	virtual bool hasNamedInput() const;
	virtual bool hasNamedOutput() const;
	virtual void setEquation();
	virtual Image * createImage(const ImageKey& oKey);
	virtual void setOutputValue(int, int iValue);
	virtual void setUndefinedValue(int iUndefinedValue);
	virtual int getUndefinedValue() const;

	virtual int output(int = 0);
	virtual void flush(int value);
	virtual void forceOutputChange();
	virtual bool outputChanged();

	virtual void Calculate(int);
	virtual void Propagate(int burst_step);

	virtual void setEquation(char cEquation);
	virtual QueueInfo parseEquation();

	// qualifiedOutputName

	// getAllEquations

private:
	Calculator m_oCalc;
	int m_iLastResult;
	int m_iCurrentResult;
	bool m_bForceOutputChange;
};

#endif
