/***************************************************************************
 *   Copyright (C) 2004 by Alessandro Bonometti                            *
 *   bauno@bauniga.baita                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PREFDIALOG_H
#define PREFDIALOG_H

#include <kdialogbase.h>
#include "prefgeneral.h"
#include "prefdecode.h"
#include "prefheader.h"
#include <klocale.h>
#include <kiconloader.h>
#include <qlayout.h>

class PrefHeader;
class PrefGeneral;
class PrefDecode;
class PrefView;

/**
@author Alessandro Bonometti
*/
class PrefDialog : public KDialogBase {
    Q_OBJECT
	
	PrefGeneral *prefGeneral;
	PrefDecode *prefDecode;

	PrefView *prefView;	
	PrefHeader *prefHeader;

	bool mkDeepDir(QString dirName);
	bool checkAndCreateDir(QString dirName);
public:
    PrefDialog(QWidget *parent = 0, const char *name = 0);

    ~PrefDialog();
protected slots:
	virtual void accept();
	virtual void reject();
	virtual void slotCancel();

};

#endif
