/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "backupconfigdialog.h"

#include <klocale.h>
#include <qlayout.h>
#include <kurl.h>
#include <dcopref.h>
#include <kdebug.h>
#include <kactivelabel.h>
#include <kmimetype.h>
#include <qpixmap.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kprogress.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <kmessagebox.h>
#include <kapplication.h>
#include <kiconloader.h>
#include <qvaluelist.h>

#include "backupconfig.h"

BackupConfigDialog::BackupConfigDialog(QWidget *parent):KDialogBase(Plain, i18n("Configure backups"),
	Help|Cancel|Ok, Cancel, parent, "configBackups", true, false)
{
	KIconLoader *icons = KGlobal::iconLoader();


	QFrame *page = plainPage();
	QVBoxLayout *topLayout = new QVBoxLayout( page, 0, KDialog::spacingHint() );
	m_backupListWidget = new BackupListWidget(page,"backupListWidget");
	topLayout->addWidget( m_backupListWidget );
	setMainWidget(page);

	connect( this, SIGNAL( okClicked()),this, SLOT(saveSettings()));
}

void BackupConfigDialog::saveSettings()
{
	m_backupListWidget->slotSaveSettings();
}

void BackupConfigDialog::readSettings()
{

}

#include "backupconfigdialog.moc"
