/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _KDISSOOOIMPRESS_H
#define _KDISSOOOIMPRESS_H

#include <qstringlist.h>
#include <qobject.h>
#include <klibloader.h>
#include "DGenerator.h"

class kdissOOOimpressFactory : KLibFactory { Q_OBJECT public: QObject *createObject(QObject *, const char *, const char *, const QStringList & = QStringList()); };

class DDataItem;
/**
 * OpenOffice.org impress document generator
 *
 * @short OpenOffice.org impress document generator
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 */
class kdissOOOimpress : public DGenerator
{
    public:
	kdissOOOimpress() : DGenerator() {}
	~kdissOOOimpress() {}

	const QString identifikation();
	const QString fullName();
	const QString group();
	const QString description();
	const QString quickstart();

	static int m_piclocation;

    private:
	bool writeMaindoc(DDataItem*, const QString &);
	void writeItem(DDataItem* item, QTextStream & s, int level);

	void writeCompleteSlide(DDataItem* item, QTextStream & s);
	void writeBullet(DDataItem* item, QTextStream & s, int level);

	void writePics(DDataControl*, QString);
	void writeDownPics(DDataItem* item, QTextStream & s);
	void outputData(DDataItem* item, QTextStream & s, int level);

	/// write recursively the pics of a tree to the manifest file
	void writeItemPic(DDataControl*, DDataItem *item, QTextStream & m);

	static int m_slidecount;
};

#endif // _KDISSOOOIMPRESS_H
