/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qmap.h>
#include <qpixmap.h>
#include <qtextcodec.h>
#include <qregexp.h>
#include <qwmatrix.h>
#include <qrect.h>

#include <kurl.h>
#include <klocale.h>
#include <kdebug.h>
#include <ktempdir.h>
#include <kgenericfactory.h>

#include "settings.h"
#include "aux.h"
#include "DItem.h"
#include "DDataControl.h"
#include "DDataItem.h"
#include "KDissertPart.h"

#include "DCanvasView.h"
#include "DCanvasItem.h"

#include "kdissapplet.h"

K_EXPORT_COMPONENT_FACTORY(libkdissapplet, kdissappletFactory)
	QObject *kdissappletFactory::createObject(QObject *part, const char *, const char *, const QStringList &) { return new kdissapplet(part); }

kdissapplet::kdissapplet() : DGenerator()
{
}

kdissapplet::kdissapplet(QObject* obj) : DGenerator(obj)
{
}

kdissapplet::~kdissapplet() {}

const QString kdissapplet::identifikation()
{
	return "kdissapplet";
}

const QString kdissapplet::fullName()
{
	return i18n("Java Applet");
}

const QString kdissapplet::group()
{
	return i18n("HTML");
}

const QString kdissapplet::description()
{
	return i18n("This template generates a Java applet that can be added to a website. It can be viewed using a Java-enabled web browser (konqueror, firefox for example)");
}

const QString kdissapplet::quickstart()
{
	return i18n("You will need a Java development kit properlty installed (javac, jar) for building the applet. Go into the directory created and view the applet with \"make view\".");
}

void kdissapplet::writeItem(DDataItem* item, QTextStream & s, int level)
{
	s<<"\tif ("<<endl;

	//s<<" /* zoom is "<<m_zoom<<" */"<<endl;

	DCanvasItem *citem = m_canvasview->canvasItem(item->Id());


	QRect r = citem->rect();

	//QPoint bottomRight = m_canvasview->viewportToContents( r.bottomRight() );
	//QPoint topLeft = m_canvasview->viewportToContents( r.topLeft() );

	//QPoint bottomRight = m_canvasview->contentsToViewport( r.bottomRight() );
	//QPoint topLeft = m_canvasview->contentsToViewport( r.topLeft() );

        QRect enclosingsize = m_canvasview->canvasSize();

        r.moveBy(-enclosingsize.x(), -enclosingsize.y());

	QPoint bottomRight =  r.bottomRight();
	QPoint topLeft = r.topLeft();


	s<<"x > "<<topLeft.x()<<" && ";
	s<<"y > "<<topLeft.y()<<" && ";
	s<<"x < "<<bottomRight.x()<<" && ";
	s<<"y < "<<bottomRight.y();

	s<<")"<<endl;
	s<<"\t{"<<endl;
	s<<"return \""<<protectCode(item->m_text)<<"\";"<<endl;
	s<<"\t}"<<endl;

	for (unsigned int i = 0; i<item->countChildren(); i++)
	{
		writeItem((DDataItem*) m_data->Item(item->childNum(i)), s, level+1);
	}
}

bool kdissapplet::writeMaindoc(DDataItem *root, const QString & path)
{
	KDissertPart *part = (KDissertPart*) (parent());
	m_canvasview = part->getCanvas();

	if (!m_canvasview) return 0;

	QString picpath = path + "/pics/map.png";
	m_data->setItemSelected(DItem::NOITEM, NULL);
	
	part->savePicURL( KURL(picpath) );

	QFile textfile(path+"/README");
        if (!textfile.open(IO_WriteOnly | IO_Append) )
        {
                kdDebug()<<"could not open html file for append :-/"<<endl;
                return false;
        }

        QTextStream u(&textfile);
        if (Settings::templatesUTF8())
        {
                u.setEncoding(QTextStream::UnicodeUTF8);
        }
	u<<i18n("This is kadapplet v0.1")<<"\n";
	u<<i18n("It requires a working java installation (javac, jar, appletviewer) for running")<<"\n";
	u<<"\n";
	u<<i18n("To launch the applet, use the following command:")<<"\n";
	u<<"cd "<<path<<" && make view\n\n";
	u<<i18n("To build the applet, use the following command:")<<"\n";
	u<<"cd "<<path<<" && make\n";
	textfile.close();
	

	QFile textfile2(path+"/TextCoord.java");
	if (!textfile2.open(IO_WriteOnly | IO_Append) )
	{
		kdWarning()<<"could not open java file for append :-/"<<endl;
		return false;
	}

	QTextStream v(&textfile2);
	v.setEncoding(QTextStream::UnicodeUTF8);

	v<<"public class TextCoord"<<endl;
	v<<"{"<<endl;
        v<<"public static String coordToText(double x, double y)"<<endl;
        v<<"{"<<endl;

	writeItem(root, v, 0);

	v<<"return \"\";"<<endl;
	v<<"}\n}\n"<<endl;
	textfile2.close();
	
	notifyDocGenerated( path+"/README" );

	return true;
}

#include "kdissapplet.moc"
