// -*- c++ -*-
/***************************************************************************
                           kdetv_grabber.h
                           ---------------
    begin                : Thu Oct 27 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __KDETV_V4L2GRABBER_H
#define __KDETV_V4L2GRABBER_H

#include <qobject.h>
#include <qthread.h>
#include <qmutex.h>
#include <qsize.h>

#include "kdetvvideo/kdetvimage.h"

class QVideoStream;
class V4L2Dev;
class KdetvImageFilterContext;
class KdetvImagePool;
class KdetvImageFilter;
class KdetvFormatConversionFilter;

// History: four fields
#define V4L2GRABBER_CONTEXT_HISTORY 4

/*
 * The field images need to be "faked" from progessive images.
 * The algorithm is simple, but the last two fields must not be
 * accessed. Depending on the order, the image with buffer may be
 * deleted while it's corresponding fake field image is still queued.
 */
#define V4L2GRABBER_HISTORY V4L2GRABBER_CONTEXT_HISTORY+2


class V4L2Grabber : public QObject, public QThread
{
public:
	V4L2Grabber(QObject *owner, V4L2Dev *dev, QVideoStream* vs, KdetvImage::ImageFormat fmt);
	virtual ~V4L2Grabber();

	virtual void run();
	void stop() { _stop = true; }
    QMutex& mutex() { return _devMutex; }

    int _fieldTime;
    KdetvImage::ImageType _mostRecentField;
    bool _fullFrameRate;
    KdetvImageFilter* _flt;
    KdetvFormatConversionFilter* _fmtConv;

private:
	QObject *_owner;
	V4L2Dev *_d;
	volatile bool _stop;
	QVideoStream* _vs; 
    QMutex _devMutex;
    QSize _inputSize;
    KdetvImage::ImageFormat _fmt; 
    KdetvImagePool* _poolWithBuffer;
    KdetvImagePool* _poolWithoutBuffer;
    KdetvImageFilterContext* _ctx;
    KdetvSharedImage* _images[V4L2GRABBER_HISTORY];
};

class V4L2ErrorEvent : public QEvent
{
public:
    V4L2ErrorEvent(const QString& msg)
        : QEvent(QEvent::User),
          _msg(msg)
    {
    }

    ~V4L2ErrorEvent()
    {
    }

    QString _msg;
};


struct V4L2GrabberLocker
{
    V4L2GrabberLocker(V4L2Grabber* g)
        : _g(g) 
    {
        if (_g)
            _g->mutex().lock();
    }

    ~V4L2GrabberLocker()
    {
        if (_g)
            _g->mutex().unlock();
    }

    V4L2Grabber* _g;
};

#endif

