// -*- c++ -*-
/***************************************************************************
                           overscan.h
                           ----------
    begin                : Thu Jun 24 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef OVERSCAN_H
#define OVERSCAN_H

#include "overscaniface.h"
#include <kaction.h>
#include <kxmlguiclient.h>
#include <kdetvfilterplugin.h>

class OverscanPlugin : public KdetvFilterPlugin, virtual public KXMLGUIClient, virtual public OverscanIface
{
    Q_OBJECT


public:
    OverscanPlugin(Kdetv* ktv, const QString& cfgkey, QObject* parent = 0, const char* name=0);
    virtual ~OverscanPlugin();

    virtual void installGUIElements(KXMLGUIFactory * guiFactory,
                                    KActionCollection *actionCollection);
    
    virtual void removeGUIElements(KXMLGUIFactory * guiFactory,
                                   KActionCollection *actionCollection);
    
private slots:
    void overscanPlus();
    void overscanMinus();


private:
    void overscanChanged();

    KAction* _plusAction;
    KAction* _minusAction;
};

#endif // OVERSCAN_H
