/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KBIBTEXWEBQUERYSPIRESHEP_H
#define KBIBTEXWEBQUERYSPIRESHEP_H

#include <webquery.h>

namespace KBibTeX
{
    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQuerySpiresHepWidget : public WebQueryWidget
    {
        Q_OBJECT
    public:
        WebQuerySpiresHepWidget( QWidget *parent, const char *name = 0 );

        KComboBox *comboBoxMirror;
        KComboBox *comboBoxType;
        QCheckBox *m_checkBoxFetchAbstracts;

    protected:
        virtual void init();
    };

    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQuerySpiresHep : public WebQuery
    {
        Q_OBJECT
    public:
        WebQuerySpiresHep( QWidget* parent );
        virtual ~WebQuerySpiresHep();

        void query();

        QString title();
        QString disclaimer();
        QString disclaimerURL();

        WebQueryWidget *widget();

        static const QString mirrorNames[];
        static const QString mirrorURLs[];

    protected:
        void cancelQuery() { /* nothing */ };

    private:
        WebQuerySpiresHepWidget *m_widget;

        void fetchArxivAbstract( BibTeX::Entry *entry );
    };

}

#endif
