/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

#include "kz-dbus-embed-delegate.h"

#include "kz-module-impl.h"
#include "kz-marshalers.h"

static gchar *socket_address = NULL;
static DBusServer *server = NULL;
static GList *embeds_queue = NULL;

static void
new_connection_func (DBusServer *dbus_server, DBusConnection *connection, gpointer user_data)
{
    DBusGConnection *g_connection;
    KzDBusEmbedDelegate *embed;
    GList *last;

    dbus_connection_setup_with_g_main(connection, NULL);

    g_connection = dbus_connection_get_g_connection(connection);
    dbus_g_connection_ref(g_connection);
    last = g_list_last(embeds_queue);
    embed = last->data;
    embeds_queue = g_list_remove_link(embeds_queue, last);
    dbus_g_connection_register_g_object(g_connection,
                                        KZ_DBUS_EMBED_DELEGATE_PATH,
                                        G_OBJECT(embed));
    kz_dbus_embed_delegate_set_connection(embed, g_connection);
}

static gchar *
setup_dbus (void)
{
    DBusError error;

    dbus_error_init(&error);
    server = dbus_server_listen("unix:tmpdir=/tmp/kazehakase/dbus-server", &error);
    if (!server) {
        g_print("%s\n", error.message);
        dbus_error_free(&error);
    }

    dbus_g_object_register_marshaller(_kz_marshal_VOID__UINT_STRING,
                                      G_TYPE_NONE,
                                      G_TYPE_UINT,
                                      G_TYPE_STRING,
                                      G_TYPE_INVALID);
    dbus_g_object_register_marshaller(_kz_marshal_VOID__INT_STRING_STRING_STRING_STRING_INT_INT_INT_INT,
                                      G_TYPE_NONE,
                                      G_TYPE_INT,
                                      G_TYPE_STRING,
                                      G_TYPE_STRING,
                                      G_TYPE_STRING,
                                      G_TYPE_STRING,
                                      G_TYPE_INT,
                                      G_TYPE_INT,
                                      G_TYPE_INT,
                                      G_TYPE_INT,
                                      G_TYPE_INVALID);

    dbus_server_setup_with_g_main(server, NULL);
    dbus_server_set_new_connection_function(server, new_connection_func, NULL, NULL);
    return dbus_server_get_address(server);
}

G_MODULE_EXPORT void
KZ_MODULE_IMPL_INIT (GTypeModule *module)
{
    kz_dbus_embed_delegate_register_type(module);
    socket_address = setup_dbus();
}

G_MODULE_EXPORT void
KZ_MODULE_IMPL_EXIT (void)
{
    g_free(socket_address);
    dbus_server_disconnect(server);
}

G_MODULE_EXPORT GObject *
KZ_MODULE_IMPL_INSTANTIATE (const gchar *first_property,
                            va_list      var_args)
{
    GObject *embed;

    /* embed = g_object_new_valist(KZ_TYPE_DBUS_EMBED_DELEGATE, first_property, var_args); */
    embed = G_OBJECT(kz_dbus_embed_delegate_new(socket_address));
    embeds_queue = g_list_append(embeds_queue, embed);
    return embed;
}

G_MODULE_EXPORT const gchar *
KZ_MODULE_IMPL_GET_NAME (void)
{
    return "EmbedProcessDelegate";
}

/* 
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
