/*
    snesrommetadata.cpp - Extract metadata(information) from SNES ROM file.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "gbarommetadata.h"

// Qt includes
#include <qdatastream.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>
#include <kmdcodec.h>

#include "nintendomakerlist.h"

GbaRomMetaData::GbaRomMetaData()
 : Kamefu::DefaultRomMetaData()
{
}


GbaRomMetaData::~GbaRomMetaData()
{
}


Kamefu::RomMetaInformation GbaRomMetaData::extractMetaInformation(KFileItem* item)
{
    return DefaultRomMetaData::extractMetaInformation(item);
}

Kamefu::RomMetaInformation GbaRomMetaData::extractMetaInformation(QIODevice* device)
{
	QByteArray gameCode(4), makerCode(2);
	QString md5Hash, countryName(i18n("Unknown")), editorName(i18n("Unknown"));
	
	// Generate the MD5 Hash
	KMD5 context(0L);
	context.update(*device);
	md5Hash = context.hexDigest();

	QDataStream stream(device);
	stream.setByteOrder(QDataStream::LittleEndian);

	// Skip the JUMP ARM command, nintendo logo and internalName
	device->at(0xAC);

	// Read the game code
	stream.readRawBytes(gameCode.data(), gameCode.size());
	// Read the maker code
	stream.readRawBytes(makerCode.data(), makerCode.size());

	// Get the information
	// Get the editor name from the maker code
	int result=0;
	bool ok;
	QString sMaker(makerCode);
	result = sMaker.toInt(&ok, 16);

	result = (result >> 4) * 36 + (result & 0x0f);
	if(result > 0 || result <= nintendoMakerListLength)
		editorName = nintendoMakerList[result];

	// Try to guess the country from the gamecode
	if(gameCode[3] == 'J')
	{
		countryName = i18n("Japan");
	}
	else if(gameCode[3] == 'P')
	{
		countryName = i18n("Europe");
	}
	else if(gameCode[3] == 'E')
	{
		countryName = i18n("America");
	}

	Kamefu::RomMetaInformation romMetaData;
	romMetaData.setEditor(editorName);
	romMetaData.setCountry(countryName);
	romMetaData.setMd5Hash(md5Hash);

	return romMetaData;
}
