/******************************************************************************
	metadataedit.h - Provide a means to view/edit ROM metadata info.
	
	Copyright (c) 2006 by Brian S. Stephan
	bssteph@incorporeal.org
	
	Copyright (c) 2006 by Michaël Larouche <michael.larouche@kdemail.net>

	Based on code in kdemultimedia/juk/tageditor.[h/cpp]:
	(c) 2002 - 2004 by Scott Wheeler
	
	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; either version 2 of the License, or     *
	* (at your option) any later version.                                   *
	*                                                                       *
	*************************************************************************
	
 *****************************************************************************/

#ifndef KAMEFU_UIMETADATAEDIT_H
#define KAMEFU_UIMETADATAEDIT_H

#include <qwidget.h>

#include <kurl.h>
/**
 * @brief Provide a means to view/edit ROM metadata info.
 * This is a widget which modifies the metadata for one ROM in the database.
 * It does not modify the ROM on disk in any way.
 *
 * @author Brian S. Stephan <bssteph@incorporeal.org>
 * @author Michaël Larouche <michael.larouche@kdemail.net>
*/
class MetadataEdit : public QWidget
{
	Q_OBJECT
public:
	/**
	 * Create MetadataEdit in single ROM edit mode.
	 * @param romUrl Path of the ROM
	 * @param parent the parent of this widget.
	 * @param name widget's name
	 */
	MetadataEdit(const QString &romUrl, QWidget *parent = 0, const char *name = 0);
	/**
	 * Create MetadataEdit in multiple ROMs edit mode.
	 * @param romList List of ROM url.
	 * @param parent the parent of this widget.
	 * @param name widget's name
	 */
	MetadataEdit(const KURL::List &romList, QWidget *parent = 0, const char *name = 0);
	
	virtual ~MetadataEdit();

public slots:
	/**
	 * Save the data in the widget.
	 */
	void save();
	/**
	 * Set the ROM to display in the widget.
	 * @param romUrl the ROM to load
	 */
	void loadSingleRom(const QString &romUrl);
	/**
	 * Set the common information to be displayed in the widget.
	 * @param romList List of ROM to load.
	 */
	void loadRoms(const KURL::List &romList);

private slots:
	/**
	 * @internal
	 * Init layout and connection s.
	 */
	void init();
	/**
	 * Note that fields in the widget have changed.
	 */
	void slotFieldsChanged();

signals:
	/**
	 * Changes to a single metadata have been applied.
	 */
	void metadataChanged(const QString &romUrl);
	/**
	 * Changes to a group of metadata have been applied
	 */
	void metadataChanged(const KURL::List &romList);

	/**
	 * This signal is emitted got changed(though not saved yet)
	 * Can be used to enable/disable a save button for example.
	 */
	void changed(bool changed);

private:
	/**
	 * Save the metadata to the database.
	 */
	void saveMetaInformation();
	/**
	 * Load the metadata from the database and populate widget fields with it.
	 */
	void showMetaInformation();
	/**
	 * Do all of the field layout in the widget.
	 */
	void setupLayout();
	/**
	 * Connect calls.
	 */
	void setupConnections();
	/**
	 * Convenience function to make adding elements to the widget easier.
	 * Handles layout for a field with corresponding label and icon.
	 * Straight out of JuK code minus some details.
	 * @param text field label
	 * @param item pointer to the field
	 * @param layout the layout to add the item to
	 * @param iconName name of the icon to load
	 */
	void addItem(const QString &text, QWidget *item, QBoxLayout *layout, const QString &iconName = QString::null);
	
private:
	class Private;
	Private *d;
};

#endif
