/*
    kamefucollectionconfig.h - Collection configuration

    Copyright (c) 2006      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef KAMEFUDATABASECONFIG_H
#define KAMEFUDATABASECONFIG_H

#include <kcmodule.h>

/**
 * Basic Database Configuration module.
 * @author Michaël Larouche
 */
class KamefuCollectionConfig : public KCModule
{
	Q_OBJECT
public:
	KamefuCollectionConfig(QWidget* parent, const char* name, const QStringList& args);
	~KamefuCollectionConfig();

public slots:
	virtual void save();
	virtual void load();

private slots:
	/**
	 * Load the database drivers into the combo box.
	 */
	void loadDatabaseDrivers();

private:
	class Private;
	Private *d;
};

#endif
