/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef SELECTSOURCEPAGE_H
#define SELECTSOURCEPAGE_H

#include "kselectsourcespage.h"
#include "wizardpagebase.h"

/**
 * @short
 * Image selection page.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
 */
class SelectSourcePage: public KSelectSourcesPage, public WizardPageBase {
  Q_OBJECT
public:
  SelectSourcePage(QWidget *parent = 0, const char *name = 0);

  void invokeHelp();
  bool processPage();
  void setupPage();

private slots:
  /**
   * Select images from the disk.
   */
  void slotLoadSourceFiles();
  /**
   * Remove images from the list.
   */
  void slotRemoveSourceFile();
  /**
   * Move up or down the items in the image list.
   */
  void slotModifyImageSourceList();
};

#endif
