/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//own includes
#include "selectsourcepage.h"
#include "kalleryglobals.h"

#include "kalleryfunctions.h"

//KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>

//Qt includes
#include <qlabel.h>

SelectSourcePage::SelectSourcePage(QWidget *parent, const char *name)
    :KSelectSourcesPage(parent, name)
{
  LogoPixmap->setPixmap(QPixmap(KalleryGlobals::ref()->baseDir() + "images/kallery.png", 0, QPixmap::Auto));
  ImageUpBtn->setIconSet(BarIconSet("up"));
  ImageDownBtn->setIconSet(BarIconSet("down"));
  ImageTopBtn->setIconSet(BarIconSet("top"));
  ImageBottomBtn->setIconSet(BarIconSet("bottom"));
  AddBtn->setIconSet(BarIconSet("edit_add"));
  DeleteBtn->setIconSet(BarIconSet("edit_remove"));

  connect(AddBtn, SIGNAL(clicked()), this, SLOT(slotLoadSourceFiles()));
  connect(DeleteBtn, SIGNAL(clicked()), this, SLOT(slotRemoveSourceFile()));

  connect(ImageUpBtn, SIGNAL(pressed()), this, SLOT(slotModifyImageSourceList()));
  connect(ImageDownBtn, SIGNAL(pressed()), this, SLOT(slotModifyImageSourceList()));
  connect(ImageTopBtn, SIGNAL(pressed()), this, SLOT(slotModifyImageSourceList()));
  connect(ImageBottomBtn, SIGNAL(pressed()), this, SLOT(slotModifyImageSourceList()));
}

void SelectSourcePage::slotLoadSourceFiles()
{
  KalleryGlobals::ref()->KalleryGlobals::ref()->options.imageList +=  KFileDialog::getOpenFileNames("", KalleryGlobals::ref()->imageFilter(), this, i18n("Select image files"));

  ImageListBox->clear();
  ImageListBox->insertStringList(KalleryGlobals::ref()->options.imageList,-1);
  ImageListBox->setSelected(0,true);
  ImageNumTxt->setText(i18n("%1 items.").arg(KalleryGlobals::ref()->options.imageList.count()));

  for (uint i = KalleryGlobals::ref()->options.descList.count(); i < KalleryGlobals::ref()->options.imageList.count(); i ++)
  {
    KalleryGlobals::ref()->options.descList.append(OptionType::Description());
  }
}

void SelectSourcePage::slotRemoveSourceFile()
{
  KalleryFunctions::ref()->deleteFromList(ImageListBox, KalleryGlobals::ref()->options.imageList, ImageNumTxt, &KalleryGlobals::ref()->options.descList);
}

void SelectSourcePage::slotModifyImageSourceList()
{
  if (ImageTopBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ImageListBox,KalleryGlobals::ref()->options.imageList,&KalleryGlobals::ref()->options.descList,0,-1);
    ImageTopBtn->setDown(false);
  }
  if (ImageUpBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ImageListBox,KalleryGlobals::ref()->options.imageList,&KalleryGlobals::ref()->options.descList,-1,0);
    ImageUpBtn->setDown(false);
  }
  if (ImageDownBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ImageListBox,KalleryGlobals::ref()->options.imageList,&KalleryGlobals::ref()->options.descList,1,0);
    ImageDownBtn->setDown(false);
  }
  if (ImageBottomBtn->isDown())
  {
    KalleryFunctions::ref()->moveInListAndBox(ImageListBox,KalleryGlobals::ref()->options.imageList,&KalleryGlobals::ref()->options.descList,0,1);
    ImageBottomBtn->setDown(false);
  }
}

void SelectSourcePage::invokeHelp()
{
  kapp->invokeHelp("selectsources-page", "kallery");
}

bool SelectSourcePage::processPage()
{
  if (KalleryGlobals::ref()->options.imageList.isEmpty())
  {
    KMessageBox::error(this,i18n("There was no image added to the project.\nPlease add at least one image file."),i18n("Empty list error"), true);
    return false;
  }
  //Check for duplicate filename, they cause problems. It can be a long process...
  QString tmpString = "";
  uint k = 0;
  for (uint i = 0; i < KalleryGlobals::ref()->options.imageList.count();  i++)
  {
    for (uint j = i + 1; j < KalleryGlobals::ref()->options.imageList.count(); j++)
    {
      if (QFileInfo(KalleryGlobals::ref()->options.imageList[i]).fileName() == QFileInfo(KalleryGlobals::ref()->options.imageList[j]).fileName())
      {
        k++;
        if (k < 11 )
          tmpString += KalleryGlobals::ref()->options.imageList[i] + "  <->  " + KalleryGlobals::ref()->options.imageList[j] + "\n";
      }
    }
  }

  if (k > 10)
    tmpString += i18n("\n... and %1 other files are also conflicting.").arg(k-10);
  if (tmpString.isEmpty())
  {
    return true;
  }
  else
  {
    KMessageBox::error(this,i18n("Conflicting/duplicate filenames were found: \n\n %1").arg(tmpString),i18n("Duplicate filename error"),true);
    return false;
  }
}

void SelectSourcePage::setupPage()
{
  ImageListBox->clear();
  ImageListBox->insertStringList(KalleryGlobals::ref()->options.imageList,-1);
  ImageNumTxt->setText(i18n("%1 items.").arg(KalleryGlobals::ref()->options.imageList.count()));
  ImageListBox->setSelected(0,true);
}

#include "selectsourcepage.moc"
