/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own includes
#include "imagehtmlpage.h"
#include "kalleryglobals.h"

#include "kalleryfunctions.h"

//KDE includes
#include <kapplication.h>
#include <kcolordialog.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>
#include <kstandarddirs.h>

//Qt includes
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qregexp.h>
#include <qtoolbutton.h>

ImageHtmlPage::ImageHtmlPage(QWidget *parent, const char *name)
    :KImageHtmlPage(parent, name)
{
  LogoPixmap->setPixmap(QPixmap(KalleryGlobals::ref()->baseDir() + "images/kallery.png", 0, QPixmap::Auto));
  BackColorBtn->setIconSet(BarIconSet("colorize"));
  TextColorBtn->setIconSet(BarIconSet("colorize"));
  VisitedColorBtn->setIconSet(BarIconSet("colorize"));
  OpenNextPic->setIconSet(BarIconSet("fileopen"));
  OpenPrevPic->setIconSet(BarIconSet("fileopen"));
  OpenBackPic->setIconSet(BarIconSet("fileopen"));
  ImageCSSSelBtn->setIconSet(BarIconSet("fileopen"));

  connect(OpenNextPic, SIGNAL(clicked()), this, SLOT(slotSelectNextPic()));
  connect(OpenPrevPic, SIGNAL(clicked()), this, SLOT(slotSelectPrevPic()));
  connect(OpenBackPic, SIGNAL(clicked()), this, SLOT(slotSelectBackPic()));
  connect(BackColorBtn, SIGNAL(clicked()), this, SLOT(slotSelectImageBackColor()));
  connect(TextColorBtn, SIGNAL(clicked()), this, SLOT(slotSelectImageTextColor()));
  connect(VisitedColorBtn, SIGNAL(clicked()), this, SLOT(slotSelectImageVisitedColor()));
  connect(ImageCSSSelBtn, SIGNAL(clicked()), this, SLOT(slotSelectImageCSS()));

  loadTemplates();
}


void ImageHtmlPage::slotSelectNextPic()
{
  QString tempStr;
  tempStr = KFileDialog::getOpenFileName(KalleryGlobals::ref()->options.nextPic, KalleryGlobals::ref()->imageFilter(),this,i18n("Select picture for Next button"));
  if (! tempStr.isEmpty()) {KalleryGlobals::ref()->options.nextPic = tempStr;}
  if (!QFileInfo(KalleryGlobals::ref()->options.nextPic).exists()) {KalleryGlobals::ref()->options.nextPic = "";}
  NextPic->setPixmap(QPixmap(KalleryGlobals::ref()->options.nextPic));
}


void ImageHtmlPage::slotSelectPrevPic()
{
  QString tempStr;
  tempStr = KFileDialog::getOpenFileName(KalleryGlobals::ref()->options.prevPic, KalleryGlobals::ref()->imageFilter(), this, i18n("Select picture for Previous button"));
  if (! tempStr.isEmpty())
  {
    KalleryGlobals::ref()->options.prevPic = tempStr;
  }
  if (!QFileInfo(KalleryGlobals::ref()->options.prevPic).exists())
  {
    KalleryGlobals::ref()->options.prevPic = "";
  }
  PrevPic->setPixmap(QPixmap(KalleryGlobals::ref()->options.prevPic));
}


void ImageHtmlPage::slotSelectBackPic()
{
  QString tempStr;
  tempStr = KFileDialog::getOpenFileName(KalleryGlobals::ref()->options.backPic, KalleryGlobals::ref()->imageFilter(),this,i18n("Select picture for Back button"));
  if (! tempStr.isEmpty())
  {
    KalleryGlobals::ref()->options.backPic = tempStr;
  }
  if (!QFileInfo(KalleryGlobals::ref()->options.backPic).exists())
  {
    KalleryGlobals::ref()->options.backPic = "";
  }
  BackPic->setPixmap(QPixmap(KalleryGlobals::ref()->options.backPic));
}


void ImageHtmlPage::slotSelectImageBackColor()
{
  QColor tmpColor = KalleryGlobals::ref()->options.imageBackColor;

  KColorDialog::getColor(tmpColor, this);
  BackColorFrame->setBackgroundColor(tmpColor);
}


void ImageHtmlPage::slotSelectImageTextColor()
{
  QColor tmpColor = KalleryGlobals::ref()->options.imageTextColor;
  KColorDialog::getColor(tmpColor, this);
  TextColorFrame->setBackgroundColor(tmpColor);
}

void ImageHtmlPage::slotSelectImageVisitedColor()
{
  QColor tmpColor = KalleryGlobals::ref()->options.imageVisitedColor;
  KColorDialog::getColor(tmpColor, this);
  VisitedColorFrame->setBackgroundColor(tmpColor);
}


void ImageHtmlPage::slotSelectImageCSS()
{
  QString tempStr;

  tempStr = KFileDialog::getOpenFileName(0,"*",this,i18n("Select the CSS file"));
  if(!tempStr.isEmpty())
  {
    KalleryGlobals::ref()->options.imageCSSFile = tempStr;
  }
  OwnImageCSSName->setText(KalleryGlobals::ref()->options.imageCSSFile);
}

void ImageHtmlPage::invokeHelp()
{
  kapp->invokeHelp("imagehtml-page","kallery");
}

bool ImageHtmlPage::processPage()
{
  int i = FullsizeTemplateCombo->currentItem();
  KalleryGlobals::ref()->options.fullsizeTemplateFile = fullsizeTemplateList[i].left(fullsizeTemplateList[i].find('|'));
  KalleryGlobals::ref()->options.fullsizeTemplate = FullsizeTemplateCombo->currentText();
  KalleryGlobals::ref()->options.useHtmlImages = UseHtmlPages->isChecked();
  KalleryGlobals::ref()->options.textButtons = TextButtonsBtn->isChecked();
  KalleryGlobals::ref()->options.nextStr =  NextTextEdit->text();
  KalleryGlobals::ref()->options.prevStr =  PrevTextEdit->text();
  KalleryGlobals::ref()->options.backStr =  BackTextEdit->text();
  KalleryGlobals::ref()->options.imageBackColor = BackColorFrame->backgroundColor();
  KalleryGlobals::ref()->options.imageTextColor = TextColorFrame->backgroundColor();
  KalleryGlobals::ref()->options.imageVisitedColor = VisitedColorFrame->backgroundColor();

  if (UseImageCSS->isChecked())
  {
    KalleryGlobals::ref()->options.imageCSSFile = OwnImageCSSName->text();
    if (!QFileInfo(KalleryGlobals::ref()->options.imageCSSFile).exists())
    {
      if (KMessageBox::warningYesNo(this,i18n("The file %1 is missing. Continue anyway?").arg(KalleryGlobals::ref()->options.imageCSSFile),i18n("Missing file")) == KMessageBox::No)
      {
        return false;
      }
    }
  }
  else
  {
    KalleryGlobals::ref()->options.imageCSSFile = "";
  }

  return true;
}

void ImageHtmlPage::setupPage()
{
    FullsizeTemplateCombo->clear();
  for (uint i = 0; i < fullsizeTemplateList.count(); i++)
  {
    FullsizeTemplateCombo->insertItem(fullsizeTemplateList[i].mid(fullsizeTemplateList[i].find('|')+1));
  }

  for (int i =  FullsizeTemplateCombo->count() -1; i >=0; i--)
  {
    FullsizeTemplateCombo->setCurrentItem(i);
    if (FullsizeTemplateCombo->currentText() == KalleryGlobals::ref()->options.fullsizeTemplate)
    {
      break;
    }
  }

  UseHtmlPages->setChecked(KalleryGlobals::ref()->options.useHtmlImages);
  TextButtonsBtn->setChecked(KalleryGlobals::ref()->options.textButtons);
  GraphButtonsBtn->setChecked(!KalleryGlobals::ref()->options.textButtons);
  NextTextEdit->setText(KalleryGlobals::ref()->options.nextStr);
  PrevTextEdit->setText(KalleryGlobals::ref()->options.prevStr);
  BackTextEdit->setText(KalleryGlobals::ref()->options.backStr);
  NextPic->setPixmap(QPixmap(KalleryGlobals::ref()->options.nextPic));
  PrevPic->setPixmap(QPixmap(KalleryGlobals::ref()->options.prevPic));
  BackPic->setPixmap(QPixmap(KalleryGlobals::ref()->options.backPic));
  BackColorFrame->setBackgroundColor(KalleryGlobals::ref()->options.imageBackColor);
  TextColorFrame->setBackgroundColor(KalleryGlobals::ref()->options.imageTextColor);
  VisitedColorFrame->setBackgroundColor(KalleryGlobals::ref()->options.imageVisitedColor);

  if (KalleryGlobals::ref()->options.imageCSSFile.isEmpty())
  {
    UseImageCSS->setChecked(false);
  }
  else
  {
    UseImageCSS->setChecked(true);
    OwnImageCSSName->setText(KalleryGlobals::ref()->options.imageCSSFile);
  }
}

void ImageHtmlPage::loadTemplates()
{
  QFile tmpFile;
  QString tmpString;

  fullsizeTemplateList = KGlobal::dirs()-> findAllResources("data","kallery/templates/fullsize/*.template", false, true);
  for (uint i = 0; i < fullsizeTemplateList.count(); i++)
  {
    tmpFile.setName(fullsizeTemplateList[i]);
    tmpFile.open(IO_ReadOnly);
    tmpFile.readLine(tmpString,200);
    tmpFile.readLine(tmpString,200);
    tmpString.replace(QRegExp("[<>!\n-]"),"");
    fullsizeTemplateList[i] =fullsizeTemplateList[i] + "|"+i18n(tmpString);
    tmpFile.close();
  }
}

#include "imagehtmlpage.moc"
