#! /bin/bash

# This script copies or removes external components (modules/themes) to/from
# appropriate places

ext_modules=$(ls externalmodules)
ext_themes_icons=$(ls externalthemes/icons)
ext_themes_emoticons=$(ls externalthemes/emoticons)
ext_themes_sounds=$(ls externalthemes/sounds)

function add_components() {
    # $1 -- list of components to copy
    # $2 -- source path of the components
    # $3 -- destination path of the components
    for component in $1; do
        cp -r $2/$component $3/$component
    done
}

function remove_components() {
    # $1 -- list of components to removed
    # $2 -- path of the components to be removed
    for component in $1; do
        rm -rf $2/$component
    done
}

if [ "$1" = "add" ]; then
    echo Copying external modules and themes inside the code

    # Add modules
    add_components "$ext_modules" externalmodules modules

    # Add icons
    add_components "$ext_themes_icons" externalthemes/icons varia/themes/icons

    # Add emoticons
    add_components "$ext_themes_emoticons" externalthemes/emoticons varia/themes/emoticons

    # Add sounds
    add_components "$ext_themes_sounds" externalthemes/sounds varia/themes/sounds
elif [ "$1" = "remove" ]; then
    echo Removing external modules and themes

    # Remove modules
    remove_components "$ext_modules" modules

    # Remove icons
    remove_components "$ext_themes_icons" varia/themes/icons

    # Remove emoticons
    remove_components "$ext_themes_emoticons" varia/themes/emoticons

    # Remove sounds
    remove_components "$ext_themes_sounds" varia/themes/sounds
fi

