#ifndef PYTHON_COMPAT_H
#define PYTHON_COMPAT_H

/* some things for handling issues with backwards compatibility */

/* Back-compatibility with Python 2.4 */
/* http://www.python.org/dev/peps/pep-0353/#conversion-guidelines */
#if PY_VERSION_HEX < 0x02050000 && !defined(PY_SSIZE_T_MIN)
typedef int Py_ssize_t;
# define PY_SSIZE_T_MAX INT_MAX
# define PY_SSIZE_T_MIN INT_MIN
#endif

/* Should try avoid these I think, by rewriting our functions to take
   PyObject* rather than our own types */
#if PY_VERSION_HEX < 0x02050000
typedef inquiry lenfunc;
typedef intargfunc ssizeargfunc;
typedef intobjargproc ssizeobjargproc;
#endif

#endif
