#
#  mutt_alias.py
#
#  Copyright 2002 Nick Piper <nick@nickpiper.co.uk>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Library General Public License, version 2,
#  as published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#


import string
import os.path

from jppy.api import IAddressBook
from jppy.conduit import Conduit
from jppy.core import Component, implements
from jppy.config import Option, IntOption, ExtensionOption

class MuttAliasSync(Conduit):
    """
    To use this conduit, write into your ~/.jppyrc:

    [conduit]
    enabled = jppy.conduits.mutt_alias.MuttAliasSync
    """    

    alias_file   = Option("mutt","alias_file",os.path.expanduser("~/.mutt/aliases"))
    category     = IntOption("mutt","category", 0)
    prefix       = Option("mutt","prefix","Category_")

    addressBook  = ExtensionOption("jppy","addressBook",IAddressBook,
                                  "jppy.jpilot.modern.addressBook")
    
    def post_sync(self):
        lists = {}
        cat_names = self.addressBook.getCategories()
        for cat in cat_names:
            lists[cat] = []
            
        for contact in self.addressBook.records(categories=self.category):
            if contact['email']:
                lists[cat_names[contact.category]].append(
                    "%s %s <%s>" % (contact['firstname'],
                                    contact['lastname'],
                                    contact['email']))

        self.log.info("Exporting to %s" % self.alias_file)
        aliases = open(self.alias_file,"w")
        for alias_name, alias_contents in lists.items():
            if len(alias_contents) > 0:
                aliases.write("alias %s%s %s\n" % (
                    alias_name,self.prefix,string.join(alias_contents,", ")))
        aliases.close()
