/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.jmeter.save;

import java.util.Collection;

/**
 * ListenerResultWrapper is for calculated results generated by listeners like
 * aggregate listener and monitor listener.
 */
public class ListenerResultWrapper {
    String version = "";

    Collection calculatedResults;

    long testStartTime;

    /**
     * @return Returns the sampleResults.
     */
    public Collection getSampleResults() {
        return calculatedResults;
    }

    /**
     * @param results
     *            The sampleResults to set.
     */
    public void setSampleResults(Collection results) {
        this.calculatedResults = results;
    }

    /**
     * @return Returns the testStartTime.
     */
    public long getTestStartTime() {
        return testStartTime;
    }

    /**
     * @param testStartTime
     *            The testStartTime to set.
     */
    public void setTestStartTime(long testStartTime) {
        this.testStartTime = testStartTime;
    }

    /**
     * @return Returns the version.
     */
    public String getVersion() {
        return version;
    }

    /**
     * @param version
     *            The version to set.
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
