/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <gtk/gtk.h>
#include <limits.h>

#include "aux-ui.h"
#include "djeq-ui.h"
#include "master-ui.h"
#include "monitor-ui.h"
#include "interface.h"
#include "io-menu.h"
#include "support.h"
#include "process.h"
#include "help.h"

GtkWidget *main_window;

gboolean update_meters(gpointer data);

int main(int argc, char *argv[])
{
    char rcfile[PATH_MAX], title[128];
    int fd;


#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
#endif

    printf(PACKAGE " " VERSION "\n");
    printf("(c) 2003 - 2004 S. Harris, P. Shirkey\n");
    printf("This is free software, and you are welcome to redistribute it\n" 
	   "under certain conditions; see the file COPYING for details.\n");


    /* look for the rcfile, if its there parse it */

    snprintf(rcfile, PATH_MAX, "%s/%s", getenv("HOME"), ".jackeqrc");
    if ((fd = open(rcfile, O_RDONLY)) >= 0) {	close(fd);
	printf("Using jackeqrc file: %s\n", rcfile);
	gtk_rc_parse(rcfile);
    }

    gtk_set_locale();
    gtk_init(&argc, &argv);
    add_pixmap_directory(PACKAGE_DATA_DIR "/jackeq");
    main_window = create_window1();

    snprintf(title, sizeof(title), PACKAGE " " VERSION);
    gtk_window_set_title ((GtkWindow *) main_window, title);

    gtk_widget_show(main_window);
    bind_mast();
    bind_mon();
    bind_djeq();
    bind_aux();
    bind_iomenu();

    /* start I/O processing, then run GTK main loop, until "quit" */

    process_init();
    g_timeout_add(100, update_meters, NULL);
    gtk_main();

    return 0;
}

gboolean update_meters(gpointer data)
{
//    static unsigned int    count = 0;
    
    aux_in_meter_value(aux_peak);
    mast_out_meter_value(mast_peak);
    mon_out_meter_value(mon_peak);
    
    out_meter_value(out_peak);

    /*  Only update the status once a second.  */

 //   if (count % 10) status_update (main_window);
 //   count++;


    return TRUE;
}

/* vi:set ts=8 sts=4 sw=4: */
