/*
 * window.h: header file for window.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright (c) 1990 Michael Sandrof.
 * Copyright (c) 1991, 1992 Troy Rollo.
 * Copyright (c) 1992-2004 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#)$eterna: window.h,v 1.48 2004/01/06 06:06:32 mrg Exp $
 */

#ifndef __window_h_
#define __window_h_

/*
 * Define this if you want to play with the new window feature, 
 * CREATE, that allows you to start new iscreen or xterm windows
 * connected to the ircII client.
 */
#define	WINDOW_CREATE

#if defined(M_UNIX) || !defined(HAVE_SYS_UN_H)
#undef WINDOW_CREATE
#endif /* M_UNIX */

/*
 * Define this if you want ircII to scroll after printing a line,
 * like it used to (2.1.5 and back era), not before printing the
 * line.   Its a waste of a line to me, but what ever people want.
 * Thanks to Veggen for telling me what to do for this.
 */
#undef SCROLL_AFTER_DISPLAY

#include "hold.h"
#include "lastlog.h"
#include "edit.h"
#include "menu.h"

/* used by the update flag to determine what needs updating */
#define REDRAW_DISPLAY_FULL 1
#define REDRAW_DISPLAY_FAST 2
#define UPDATE_STATUS 4
#define REDRAW_STATUS 8

#define	LT_UNLOGGED	0
#define	LT_LOGHEAD	1
#define	LT_LOGTAIL	2

/* var_settings indexes */
#define OFF 0
#define ON 1
#define TOGGLE 2

/* used in window_traverse() */
typedef struct window_traverse_stru
{
	int	flag;
	Window	*which;
	Screen	*screen;
	int	visible;
} Win_Trav;

	void	set_scroll_lines(int);
	void	set_scroll(int);
	void	reset_line_cnt(int);
	void	set_continued_line(u_char *);
	void	set_underline_video(int);
	void	window_get_connected (Window *, u_char *, int,
				      u_char *, u_char *, int);
	void	erase_display(Window *);
	int	unhold_windows(void);
	Window	*traverse_all_windows(int *);
	Window	*window_traverse(Win_Trav *);
	void	add_to_invisible_list(Window *);
	void	delete_window(Window *);
	Window	*add_to_window_list(Window *);
	void	erase_display(Window *);
	void	set_scroll(int);
	void	set_scroll_lines(int);
	void	update_all_status(void);
	void	set_query_nick(u_char *);
	u_char	*query_nick(void);
	void	update_window_status(Window *, int);
	void	windowcmd(u_char *, u_char *, u_char *);
	void	next_window(u_int, u_char *);
	void	swap_last_window(u_int, u_char *);
	void	swap_next_window(u_int, u_char *);
	void	previous_window(u_int, u_char *);
	void	swap_previous_window(u_int, u_char *);
	void	back_window(u_int, u_char *);
	void	window_kill_swap(void);
	int	is_current_channel(u_char *, int, int);
	void	redraw_all_status(void);
	void	message_to(u_int);
	void	message_from(u_char *, int);
	void	unstop_all_windows(u_int, u_char *);
	void	set_prompt_by_refnum(u_int, u_char *);
	int	number_of_windows(void);
	void	clear_window_by_refnum(u_int);
	u_int	current_refnum(void);
	Window	*get_window_by_refnum(u_int);
	u_char	*get_target_by_refnum(u_int);
	u_char	*get_prompt_by_refnum(u_int);
	u_char	*set_channel_by_refnum(u_int, u_char *);
	u_char	*get_channel_by_refnum(u_int);
	void	window_set_server(int, int, int);
	Window	*get_window_by_name(u_char *);
	int	get_window_server(u_int);
	int	message_from_level(int);
	void	restore_message_from(void);
	void	save_message_from(void);
	void	window_check_servers(void);
	void	set_current_window(Window *);
	void	set_level_by_refnum(u_int, int);
	Window	*is_bound(u_char *, int);
	void	add_window_to_server_group(Window *, u_char *);
	void	delete_window_from_server_group(Window *, u_char *);
	void	window_restore_server(int);
	void	window_set_prev_server(int);

extern	Window	*invisible_list;
extern	int	underline;
extern	int	who_level;
extern	u_char	*who_from;
extern	int	in_window_command;
extern	u_int	window_display;

#define WINDOW_NOTIFY	((unsigned) 0x0001)
#define WINDOW_NOTIFIED	((unsigned) 0x0002)

/* for window_set_server() -Sol */
#define	WIN_ALL		0x01
#define	WIN_TRANSFER	0x02
#define	WIN_FORCE	0x04

#endif /* __window_h_ */
