/*
 * hook.h.proto: header for hook.c
 * 
 * Copyright (c) 1990 Michael Sandrof.
 * Copyright (c) 1991, 1992 Troy Rollo.
 * Copyright (c) 1992-2004 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * NOTE: This file is automatically created!
 *
 * from: @(#) eterna: hook.h.proto,v 1.40 2004/01/06 06:04:59 mrg Exp 
 * @(#)$eterna: hook.h,v 1.37 2004/01/06 08:14:08 mrg Exp $
 */

#ifndef __hook_h_
# define __hook_h_

/* Hook: The structure of the entries of the hook functions lists */
typedef struct	hook_stru
{
	struct	hook_stru *next;	/* pointer to next element in list */
	u_char	*nick;			/* The Nickname */
	int	not;			/* If true, this entry should be
					 * ignored when matched, otherwise it
					 * is a normal entry */
	int	noisy;			/* flag indicating how much output
					 * should be given */
	int	server;			/* the server in which this hook
					 * applies. (-1 if none). If bit 0x1000
					 * is set, then no other hooks are
					 * tried in the given server if all the
					 * server specific ones fail
					 */
	int	sernum;			/* The serial number for this hook. This
					 * is used for hooks which will be
					 * concurrent with others of the same
					 * pattern. The default is 0, which
					 * means, of course, no special
					 * behaviour. If any 1 hook suppresses
					 * the * default output, output will be
					 * suppressed.
					 */
	u_char	*stuff;			/* The this that gets done */
	int	global;			/* set if loaded from `global' */
}	Hook;

/* HookFunc: A little structure to keep track of the various hook functions */
typedef struct
{
	char	*name;			/* name of the function */
	Hook	*list;			/* pointer to head of the list for this
					 * function */
	int	params;			/* number of parameters expected */
	int	mark;
	unsigned flags;
}	HookFunc;

/*
 * NumericList: a special list type to dynamically handle numeric hook
 * requests 
 */
typedef struct numericlist_stru
{
	struct	numericlist_stru *next;
	char	*name;
	Hook	*list;
}	NumericList;

#define ACTION_LIST 0
#define CHANNEL_NICK_LIST 1
#define CHANNEL_SIGNOFF_LIST 2
#define CONNECT_LIST 3
#define CTCP_LIST 4
#define CTCP_REPLY_LIST 5
#define DCC_CHAT_LIST 6
#define DCC_CONNECT_LIST 7
#define DCC_ERROR_LIST 8
#define DCC_LIST_LIST 9
#define DCC_LOST_LIST 10
#define DCC_RAW_LIST 11
#define DCC_REQUEST_LIST 12
#define DISCONNECT_LIST 13
#define ENCRYPTED_NOTICE_LIST 14
#define ENCRYPTED_PRIVMSG_LIST 15
#define EXEC_LIST 16
#define EXEC_ERRORS_LIST 17
#define EXEC_EXIT_LIST 18
#define EXEC_PROMPT_LIST 19
#define EXIT_LIST 20
#define FLOOD_LIST 21
#define HELP_LIST 22
#define HOOK_LIST 23
#define ICB_CMDOUT_LIST 24
#define ICB_ERROR_LIST 25
#define ICB_STATUS_LIST 26
#define ICB_WHO_LIST 27
#define IDLE_LIST 28
#define INPUT_LIST 29
#define INVITE_LIST 30
#define JOIN_LIST 31
#define KICK_LIST 32
#define LEAVE_LIST 33
#define LIST_LIST 34
#define MAIL_LIST 35
#define MODE_LIST 36
#define MSG_LIST 37
#define MSG_GROUP_LIST 38
#define NAMES_LIST 39
#define NICKNAME_LIST 40
#define NOTE_LIST 41
#define NOTICE_LIST 42
#define NOTIFY_SIGNOFF_LIST 43
#define NOTIFY_SIGNON_LIST 44
#define OS_SIGNAL_LIST 45
#define PUBLIC_LIST 46
#define PUBLIC_MSG_LIST 47
#define PUBLIC_NOTICE_LIST 48
#define PUBLIC_OTHER_LIST 49
#define RAW_IRC_LIST 50
#define RAW_SEND_LIST 51
#define SEND_ACTION_LIST 52
#define SEND_DCC_CHAT_LIST 53
#define SEND_MSG_LIST 54
#define SEND_NOTICE_LIST 55
#define SEND_PUBLIC_LIST 56
#define SEND_TALK_LIST 57
#define SERVER_NOTICE_LIST 58
#define SIGNOFF_LIST 59
#define TALK_LIST 60
#define TIMER_LIST 61
#define TOPIC_LIST 62
#define WALL_LIST 63
#define WALLOP_LIST 64
#define WHO_LIST 65
#define WIDELIST_LIST 66
#define WINDOW_LIST 67
#define WINDOW_KILL_LIST 68
#define WINDOW_LIST_LIST 69
#define WINDOW_SWAP_LIST 70
#define NUMBER_OF_LISTS 71

	int	do_hook(int, char *, ...);
	void	on(u_char *, u_char *, u_char *);
	void	save_hooks(FILE *, int);
	void	remove_hook(int, u_char *, int, int, int);
	void	show_hook(Hook *, char *);

extern	NumericList *numeric_list;	/* XXX */
extern	HookFunc hook_functions[];	/* XXX */

extern	int	in_on_who;

#endif /* __hook_h_ */
