/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iparticledatasubject.h"


#include "idata.h"
#include "idatalimits.h"
#include "ierror.h"
#include "iparticlefileloader.h"
#include "iparticleprobefilter.h"

//
//  Templates
//
#include "iarraytemplate.h"


IOBJECT_DEFINE_TYPE(iParticleDataSubject,ParticleData,-dp,iObjectType::_Data);


IOBJECT_DEFINE_KEY(iParticleDataSubject,DensityAttribute,ad,OffsetInt,1);
IOBJECT_DEFINE_KEY(iParticleDataSubject,OrderIsAttribute,ao,Bool,1);
IOBJECT_DEFINE_KEY(iParticleDataSubject,DownsampleFactor,df,Int,1);
IOBJECT_DEFINE_KEY(iParticleDataSubject,DownsampleMode,dm,Int,1);
IOBJECT_DEFINE_KEY(iParticleDataSubject,TypeIncluded,ti,Bool,1);
IOBJECT_DEFINE_KEY(iParticleDataSubject,UseExtras,ue,Bool,1);


iParticleDataSubject::iParticleDataSubject(iParticleFileLoader *fl, const iString &name) : iDataSubject(fl,name), mParticleLoader(fl)
{
}


const iObjectType& iParticleDataSubject::GetObjectType() const
{
	return iParticleDataSubject::Type();
}


iDataLimits* iParticleDataSubject::CreateLimits() const
{
	return iDataLimits::New(this,3,"Attribute");
}


void iParticleDataSubject::DataSubjectPackStateBody(iString &s) const
{
	this->PackValue(s,KeyTypeIncluded(),mParticleLoader->GetTypeIncluded(mId));
	this->PackValue(s,KeyDownsampleMode(),mParticleLoader->GetDownsampleMode());
	this->PackValue(s,KeyDownsampleFactor(),mParticleLoader->GetDownsampleFactor(mId));
	this->PackValue(s,KeyOrderIsAttribute(),mParticleLoader->GetOrderIsAttribute(mId));
	this->PackValue(s,KeyDensityAttribute(),mParticleLoader->GetDensityAttribute(mId));

	this->PackValue(s,KeyUseExtras(),mParticleLoader->IsUsingExtras());

	this->ParticleDataSubjectPackStateBody(s);
}


void iParticleDataSubject::DataSubjectUnPackStateBody(const iString &s)
{
	int i; bool b;

	if(this->UnPackValue(s,KeyTypeIncluded(),b))
	{
		mParticleLoader->SetTypeIncluded(mId,b);
		this->ClearCache();
	}
	if(this->UnPackValue(s,KeyDownsampleMode(),i))
	{
		mParticleLoader->SetDownsampleMode(i);
		this->ClearCache();
	}
	if(this->UnPackValue(s,KeyDownsampleFactor(),i))
	{
		mParticleLoader->SetDownsampleFactor(mId,i);
		this->ClearCache();
	}
	if(this->UnPackValue(s,KeyOrderIsAttribute(),b))
	{
		mParticleLoader->SetOrderIsAttribute(mId,b);
		this->ClearCache();
	}
	if(this->UnPackValue(s,KeyDensityAttribute(),i))
	{
		mParticleLoader->SetDensityAttribute(mId,i);
		this->ClearCache();
	}

	this->ParticleDataSubjectUnPackStateBody(s);
}


iProbeFilter* iParticleDataSubject::CreateProbeFilter(iViewSubject *vo) const
{
	return iParticleProbeFilter::New(vo);
}

