/* dir.h
 * - Directory Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef _ICECAST_DIR_H
#define _ICECAST_DIR_H

typedef struct {
#ifdef _WIN32
	long HDIR;	
	int first;
	struct _finddata_t *directory;
#else
	DIR *directory;
	struct dirent *entry;
#endif
	const char *filename;
} dir_t;

dir_t *dir_findfirst(const char *name);
int dir_findnext(dir_t *dir);
int dir_findclose(dir_t *dir);

#endif
