# This file is part of the Hotwire Shell project API.

# Copyright (C) 2007 Colin Walters <walters@verbum.org>

# Permission is hereby granted, free of charge, to any person obtaining a copy 
# of this software and associated documentation files (the "Software"), to deal 
# in the Software without restriction, including without limitation the rights 
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
# of the Software, and to permit persons to whom the Software is furnished to do so, 
# subject to the following conditions:

# The above copyright notice and this permission notice shall be included in all 
# copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
# INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
# PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE X CONSORTIUM BE 
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR 
# THE USE OR OTHER DEALINGS IN THE SOFTWARE.

from hotwire.builtin import Builtin, BuiltinRegistry, OutputStreamSchema

if '_' not in globals(): globals()['_'] = lambda x: x

class CurrentBuiltin(Builtin):
    __doc__ = _("""Returns objects generated by currently visible command.""")
    def __init__(self):
        super(CurrentBuiltin, self).__init__('current', aliases=['cur'],
                                             idempotent=True,
                                             argspec=None,
                                             output=OutputStreamSchema('any'),
                                             threaded=False)

    def execute(self, context, args):
        meta = context.current_output_metadata
        current = context.snapshot_current_output()
        if current is None:
            return
        if meta.single:
            yield current
        else:
            for obj in current:
                yield obj
BuiltinRegistry.getInstance().register_hotwire(CurrentBuiltin())
