#include "hrn-queue-controls.h"

enum {
    PROP_0,
};

enum {
    REQUEST_NEXT,
    REQUEST_PREVIOUS,
    PLAYING_CHANGED,
    LAST_SIGNAL,
};

struct _HrnQueueControlsPrivate {
    NbtkWidget *playpause;
    gboolean playing;
    guint32 play_pause_id;
    NbtkWidget *next;

#if 0
    NbtkWidget *back;
#endif
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_QUEUE_CONTROLS, HrnQueueControlsPrivate))
G_DEFINE_TYPE (HrnQueueControls, hrn_queue_controls, NBTK_TYPE_BIN);
static guint32 signals[LAST_SIGNAL] = {0,};

static void
hrn_queue_controls_finalize (GObject *object)
{
    G_OBJECT_CLASS (hrn_queue_controls_parent_class)->finalize (object);
}

static void
hrn_queue_controls_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_queue_controls_parent_class)->dispose (object);
}

static void
hrn_queue_controls_set_property (GObject      *object,
                          guint         prop_id,
                          const GValue *value,
                          GParamSpec   *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_queue_controls_get_property (GObject    *object,
                          guint       prop_id,
                          GValue     *value,
                          GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_queue_controls_class_init (HrnQueueControlsClass *klass)
{
    GObjectClass *o_class = (GObjectClass *) klass;

    o_class->dispose = hrn_queue_controls_dispose;
    o_class->finalize = hrn_queue_controls_finalize;
    o_class->set_property = hrn_queue_controls_set_property;
    o_class->get_property = hrn_queue_controls_get_property;

    g_type_class_add_private (klass, sizeof (HrnQueueControlsPrivate));

    signals[REQUEST_NEXT] = g_signal_new ("request-next",
                                          G_TYPE_FROM_CLASS (klass),
                                          G_SIGNAL_RUN_FIRST |
                                          G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                          g_cclosure_marshal_VOID__VOID,
                                          G_TYPE_NONE, 0);
    signals[REQUEST_PREVIOUS] = g_signal_new ("request-previous",
                                              G_TYPE_FROM_CLASS (klass),
                                              G_SIGNAL_RUN_FIRST |
                                              G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                              g_cclosure_marshal_VOID__VOID,
                                              G_TYPE_NONE, 0);
    signals[PLAYING_CHANGED] = g_signal_new ("request-playing-changed",
                                             G_TYPE_FROM_CLASS (klass),
                                             G_SIGNAL_RUN_FIRST |
                                             G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                             g_cclosure_marshal_VOID__BOOLEAN,
                                             G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
playpause_clicked_cb (NbtkButton       *button,
                      HrnQueueControls *controls)
{
    HrnQueueControlsPrivate *priv = controls->priv;

    priv->playing = !priv->playing;
    if (priv->playing)
        nbtk_widget_set_style_class_name (priv->playpause, "HrnControlsPause");
    else
        nbtk_widget_set_style_class_name (priv->playpause, "HrnControlsPlay");
    g_signal_emit (controls, signals[PLAYING_CHANGED], 0, priv->playing);
}

static void
next_clicked_cb (NbtkButton        *button,
                 HrnQueueControls  *controls)
{
    g_signal_emit (controls, signals[REQUEST_NEXT], 0);
}

#if 0
static void
back_clicked_cb (NbtkButton        *button,
                 HrnQueueControls  *controls)
{
    g_signal_emit (controls, signals[REQUEST_PREVIOUS], 0);
}
#endif

static void
hrn_queue_controls_init (HrnQueueControls *self)
{
    HrnQueueControlsPrivate *priv = GET_PRIVATE (self);
    NbtkWidget *table;

    self->priv = priv;

    table = nbtk_table_new ();
    clutter_container_add_actor ((ClutterContainer *) self,
                                 (ClutterActor *) table);

    priv->playpause = nbtk_button_new ();
    priv->playing = FALSE;
    nbtk_widget_set_style_class_name (priv->playpause, "HrnControlsPlay");
    clutter_actor_set_size (CLUTTER_ACTOR (priv->playpause), 60, 33);
    priv->play_pause_id = g_signal_connect (priv->playpause, "clicked",
                                            G_CALLBACK (playpause_clicked_cb),
                                            self);
    nbtk_table_add_actor_with_properties (NBTK_TABLE (table),
                                          CLUTTER_ACTOR (priv->playpause),
                                          0, 0,
                                          "x-align", 0.0,
                                          "y-align", 0.0,
                                          "x-fill", FALSE,
                                          "x-expand", FALSE,
                                          NULL);

#if 0
    priv->back = nbtk_button_new ();
    clutter_actor_set_size (CLUTTER_ACTOR (priv->back), 60, 24);
    nbtk_widget_set_style_class_name (priv->back, "HrnControlsBack");
    g_signal_connect (priv->back, "clicked",
                      G_CALLBACK (back_clicked_cb), self);
    nbtk_table_add_actor_with_properties (NBTK_TABLE (table),
                                          CLUTTER_ACTOR (priv->back), 0, 1,
                                          "x-align", 0.0,
                                          "y-align", 0.0,
                                          "x-fill", FALSE,
                                          "x-expand", FALSE,
                                          NULL);
#endif

    priv->next = nbtk_button_new ();
    clutter_actor_set_size (CLUTTER_ACTOR (priv->next), 60, 33);
    nbtk_widget_set_style_class_name (priv->next, "HrnControlsNext");
    g_signal_connect (priv->next, "clicked",
                      G_CALLBACK (next_clicked_cb), self);
    nbtk_table_add_actor_with_properties (NBTK_TABLE (table),
                                          CLUTTER_ACTOR (priv->next), 0, 2,
                                          "x-align", 0.0,
                                          "y-align", 0.0,
                                          "x-fill", FALSE,
                                          "x-expand", FALSE,
                                          NULL);
}

void
hrn_queue_controls_set_playing (HrnQueueControls *controls,
                                gboolean          playing)
{
    HrnQueueControlsPrivate *priv = controls->priv;

    g_signal_handler_block (priv->playpause, priv->play_pause_id);
    priv->playing = playing;
    if (playing)
        nbtk_widget_set_style_class_name (priv->playpause, "HrnControlsPause");
    else
        nbtk_widget_set_style_class_name (priv->playpause, "HrnControlsPlay");
    g_signal_handler_unblock (priv->playpause, priv->play_pause_id);
}
