#ifndef __HRN_CONTENT_AREA_H__
#define __HRN_CONTENT_AREA_H__

#include <clutter/clutter.h>

#include <hrn-type.h>

G_BEGIN_DECLS

#define HRN_TYPE_CONTENT_AREA                                           \
   (hrn_content_area_get_type())
#define HRN_CONTENT_AREA(obj)                                           \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_CONTENT_AREA,                  \
                                HrnContentArea))
#define HRN_CONTENT_AREA_CLASS(klass)                                   \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_CONTENT_AREA,                     \
                             HrnContentAreaClass))
#define IS_HRN_CONTENT_AREA(obj)                                        \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_CONTENT_AREA))
#define IS_HRN_CONTENT_AREA_CLASS(klass)                                \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_CONTENT_AREA))
#define HRN_CONTENT_AREA_GET_CLASS(obj)                                 \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_CONTENT_AREA,                   \
                               HrnContentAreaClass))

typedef struct _HrnContentAreaPrivate HrnContentAreaPrivate;
typedef struct _HrnContentArea      HrnContentArea;
typedef struct _HrnContentAreaClass HrnContentAreaClass;

struct _HrnContentArea
{
    ClutterGroup parent;

    HrnContentAreaPrivate *priv;
};

struct _HrnContentAreaClass
{
    ClutterGroupClass parent_class;
};

GType hrn_content_area_get_type (void) G_GNUC_CONST;

void hrn_content_area_finish_preload (HrnContentArea *area);
void hrn_content_area_show (HrnContentArea *area);
void hrn_content_area_hide (HrnContentArea *area);
void hrn_content_area_restore_state (HrnContentArea  *area,
                                     HrnStateManager *state_manager);
void hrn_content_area_set_enabled (HrnContentArea *area,
                                   gboolean        enabled);
void hrn_content_area_preload (HrnContentArea *area);
void hrn_content_area_set_zoom (HrnContentArea *area,
                                HrnZoomLevel    zoom_level);
void hrn_content_area_set_query (HrnContentArea *area,
                                 const char     *query);
void hrn_content_area_set_source (HrnContentArea *area,
                                  HrnSource      *source);

G_END_DECLS

#endif /* __HRN_CONTENT_AREA_H__ */
