#include "hrn.h"
#include "hrn-cluster-thumbnail.h"
#include "hrn-texture-cache.h"
#include "hrn-tileable.h"

enum {
    PROP_0,
};

struct _HrnClusterThumbnailPrivate {
    GPtrArray *thumbs;
};

#define MAX_CLUSTER_ITEMS 5 /* Max number of items displayed in a thumbnail */

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_CLUSTER_THUMBNAIL, HrnClusterThumbnailPrivate))
G_DEFINE_TYPE (HrnClusterThumbnail, hrn_cluster_thumbnail, CLUTTER_TYPE_GROUP);

static void
hrn_cluster_thumbnail_finalize (GObject *object)
{
    HrnClusterThumbnail *self = (HrnClusterThumbnail *) object;
    HrnClusterThumbnailPrivate *priv = self->priv;

    g_ptr_array_free (priv->thumbs, TRUE);

    G_OBJECT_CLASS (hrn_cluster_thumbnail_parent_class)->finalize (object);
}

static void
hrn_cluster_thumbnail_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_cluster_thumbnail_parent_class)->dispose (object);
}

static void
hrn_cluster_thumbnail_set_property (GObject      *object,
                                    guint         prop_id,
                                    const GValue *value,
                                    GParamSpec   *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_cluster_thumbnail_get_property (GObject    *object,
                                    guint       prop_id,
                                    GValue     *value,
                                    GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

struct _HoverData {
    float x;
    float y;
    float scale;
};

struct _HoverData hd_enter[MAX_CLUSTER_ITEMS + 1][MAX_CLUSTER_ITEMS] = {
    /* 0 - not used */
    {
        {0.0, 0.0, 0.0 }
    },
    /* 1 */
    {
        { 0.04, 0.14, 0.86 }
    },
    /* 2 */
    {
        { 0.2, 0.3, 0.7 },
        { 0.04, 0.1, 0.7 },
    },
    /* 3 */
    {
        { 0.2, 0.4, 0.6 },
        { 0.02, 0.12, 0.5 },
        { 0.4, 0.12, 0.5 },
    },
    /* 4 */
    {
        { 0.03, 0.13, 0.43 },
        { 0.47, 0.13, 0.43 },
        { 0.03, 0.57, 0.43 },
        { 0.47, 0.57, 0.43 },
    },
    /* 5 */
    {
        { 0.25, 0.35, 0.5 },
        { 0.03, 0.13, 0.43 },
        { 0.47, 0.13, 0.43 },
        { 0.03, 0.57, 0.43 },
        { 0.47, 0.57, 0.43 },
    },
};

static gboolean
hrn_cluster_thumbnail_enter (ClutterActor         *actor,
                             ClutterCrossingEvent *event)
{
    HrnClusterThumbnail *thumbnail = (HrnClusterThumbnail *) actor;
    HrnClusterThumbnailPrivate *priv = thumbnail->priv;
    int i;

    for (i = 0; i < priv->thumbs->len; i++) {
        struct _HoverData hd = hd_enter[priv->thumbs->len][i];

        clutter_actor_animate (priv->thumbs->pdata[i],
                               CLUTTER_EASE_IN_OUT_CUBIC, 250,
                               "x", hd.x * /*THUMBNAIL_WIDTH*/ 104,
                               "y", hd.y * /*THUMBNAIL_HEIGHT*/ 104,
                               "scale-x", hd.scale,
                               "scale-y", hd.scale,
                               NULL);
    }
    return FALSE;
}

static float clustered_scale[MAX_CLUSTER_ITEMS] = {
    0.55, 0.54, 0.486, 0.4374, 0.39366
};

static float clustered_x[MAX_CLUSTER_ITEMS] = {
    27.0, 13.2, 45.24, 19.356, 50.78
};

static float clustered_y[MAX_CLUSTER_ITEMS] = {
    43.2, 25.92, 27.552, 9.3312, 17.6
};

static gboolean
hrn_cluster_thumbnail_leave (ClutterActor         *actor,
                             ClutterCrossingEvent *event)
{
    HrnClusterThumbnail *thumbnail = (HrnClusterThumbnail *) actor;
    HrnClusterThumbnailPrivate *priv = thumbnail->priv;
    int i;

    for (i = 0; i < priv->thumbs->len; i++) {
        clutter_actor_animate (priv->thumbs->pdata[i],
                               CLUTTER_EASE_IN_OUT_CUBIC, 250,
                               "x", clustered_x[i],
                               "y", clustered_y[i],
                               "scale-x", clustered_scale[i],
                               "scale-y", clustered_scale[i],
                               NULL);
    }

    return FALSE;
}

static void
hrn_cluster_thumbnail_class_init (HrnClusterThumbnailClass *klass)
{
    GObjectClass *o_class = (GObjectClass *) klass;
    ClutterActorClass *a_class = (ClutterActorClass *) klass;

    o_class->dispose = hrn_cluster_thumbnail_dispose;
    o_class->finalize = hrn_cluster_thumbnail_finalize;
    o_class->set_property = hrn_cluster_thumbnail_set_property;
    o_class->get_property = hrn_cluster_thumbnail_get_property;

    a_class->enter_event = hrn_cluster_thumbnail_enter;
    a_class->leave_event = hrn_cluster_thumbnail_leave;

    g_type_class_add_private (klass, sizeof (HrnClusterThumbnailPrivate));
}

static void
hrn_cluster_thumbnail_init (HrnClusterThumbnail *self)
{
    HrnClusterThumbnailPrivate *priv = GET_PRIVATE (self);

    self->priv = priv;
    clutter_actor_set_reactive ((ClutterActor *) self, TRUE);
    priv->thumbs = g_ptr_array_new ();
}

void
hrn_cluster_thumbnail_set_elements (HrnClusterThumbnail *self,
                                    GPtrArray           *elements)
{
    HrnClusterThumbnailPrivate *priv = self->priv;
    int i;

    for (i = 0; i < elements->len && i < MAX_CLUSTER_ITEMS; i++) {
        ClutterActor *clone, *thumb;
        ClutterActor *tile;

        tile = elements->pdata[i];
        thumb = hrn_tileable_get_thumbnail ((HrnTileable *) tile);
        clone = clutter_clone_new (thumb);

        clutter_actor_set_scale (clone, clustered_scale[i], clustered_scale[i]);
        clutter_actor_set_position (clone, clustered_x[i], clustered_y[i]);
        clutter_container_add_actor ((ClutterContainer *) self, clone);
        clutter_actor_lower_bottom (clone);

        g_ptr_array_add (priv->thumbs, clone);
    }
}

void
hrn_cluster_thumbnail_set_thumbnail (HrnClusterThumbnail *self,
                                     const char          *uri,
                                     BklItemType          type)
{
    HrnClusterThumbnailPrivate *priv = self->priv;
    HrnTextureCache *cache = hrn_texture_cache_get_default ();
    ClutterActor *texture;

    if (uri == NULL) {
        texture = hrn_texture_cache_get_default_texture (cache, type);
    } else {
        texture = hrn_texture_cache_get_texture (cache, uri);
    }

    clutter_actor_set_size (texture, 104, 104);
    clutter_actor_set_scale (texture, clustered_scale[0], clustered_scale[0]);
    clutter_actor_set_position (texture, clustered_x[0], clustered_y[0]);
    clutter_container_add_actor ((ClutterContainer *) self, texture);

    g_ptr_array_add (priv->thumbs, texture);
}
