{- This module was generated from data in the Kate syntax highlighting file matlab.xml, version 1.20,
   by   -}

module Text.Highlighting.Kate.Syntax.Matlab ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Matlab"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.m;*.M"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Matlab" }
  context <- currentContext <|> (pushContext "_normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Matlab",["_normal"])], synStLanguage = "Matlab", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "_normal" -> (popContext >> return ())
    "_adjoint" -> (popContext >> return ())
    _ -> return ()
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents, synStCharsParsedInLine = 0, synStPrevChar = '\n' }

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Number","fl"),("String","st"),("System","bn"),("Incomplete String","ch"),("Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_KeywordsList = Set.fromList $ words $ "break case catch continue else elseif end for function global if otherwise persistent return switch try while"

regex_'5ba'2dzA'2dZ'5d'5cw'2a'28'3f'3d'27'29 = compileRegex "[a-zA-Z]\\w*(?=')"
regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f'28'3f'3d'27'29 = compileRegex "(\\d+(\\.\\d+)?|\\.\\d+)([eE][+-]?\\d+)?[ij]?(?=')"
regex_'5b'5c'29'5c'5d'7d'5d'28'3f'3d'27'29 = compileRegex "[\\)\\]}](?=')"
regex_'5c'2e'27'28'3f'3d'27'29 = compileRegex "\\.'(?=')"
regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a'27'28'3f'3d'5b'5e'27'5d'7c'24'29 = compileRegex "'[^']*(''[^']*)*'(?=[^']|$)"
regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a = compileRegex "'[^']*(''[^']*)*"
regex_'25'2e'2a'24 = compileRegex "%.*$"
regex_'21'2e'2a'24 = compileRegex "!.*$"
regex_'5ba'2dzA'2dZ'5d'5cw'2a = compileRegex "[a-zA-Z]\\w*"
regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f = compileRegex "(\\d+(\\.\\d+)?|\\.\\d+)([eE][+-]?\\d+)?[ij]?"
regex_'27'2b = compileRegex "'+"

defaultAttributes = [("_normal","Normal Text"),("_adjoint","Operator")]

parseRules "_normal" = 
  do (attr, result) <- (((pRegExpr regex_'5ba'2dzA'2dZ'5d'5cw'2a'28'3f'3d'27'29 >>= withAttribute "Variable") >>~ pushContext "_adjoint")
                        <|>
                        ((pRegExpr regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f'28'3f'3d'27'29 >>= withAttribute "Number") >>~ pushContext "_adjoint")
                        <|>
                        ((pRegExpr regex_'5b'5c'29'5c'5d'7d'5d'28'3f'3d'27'29 >>= withAttribute "Delimiter") >>~ pushContext "_adjoint")
                        <|>
                        ((pRegExpr regex_'5c'2e'27'28'3f'3d'27'29 >>= withAttribute "Operator") >>~ pushContext "_adjoint")
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a'27'28'3f'3d'5b'5e'27'5d'7c'24'29 >>= withAttribute "String"))
                        <|>
                        ((pRegExpr regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a >>= withAttribute "Incomplete String"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_KeywordsList >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'25'2e'2a'24 >>= withAttribute "Comment"))
                        <|>
                        ((pRegExpr regex_'21'2e'2a'24 >>= withAttribute "System"))
                        <|>
                        ((pRegExpr regex_'5ba'2dzA'2dZ'5d'5cw'2a >>= withAttribute "Variable"))
                        <|>
                        ((pRegExpr regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f >>= withAttribute "Number"))
                        <|>
                        ((pAnyChar "()[]{}" >>= withAttribute "Delimiter"))
                        <|>
                        ((pString False "..." >>= withAttribute "Operator"))
                        <|>
                        ((pString False "==" >>= withAttribute "Operator"))
                        <|>
                        ((pString False "~=" >>= withAttribute "Operator"))
                        <|>
                        ((pString False "<=" >>= withAttribute "Operator"))
                        <|>
                        ((pString False ">=" >>= withAttribute "Operator"))
                        <|>
                        ((pString False "&&" >>= withAttribute "Operator"))
                        <|>
                        ((pString False "||" >>= withAttribute "Operator"))
                        <|>
                        ((pString False ".*" >>= withAttribute "Operator"))
                        <|>
                        ((pString False ".^" >>= withAttribute "Operator"))
                        <|>
                        ((pString False "./" >>= withAttribute "Operator"))
                        <|>
                        ((pString False ".'" >>= withAttribute "Operator"))
                        <|>
                        ((pAnyChar "*+-/\\&|<>~^=,;:@" >>= withAttribute "Operator")))
     return (attr, result)

parseRules "_adjoint" = 
  do (attr, result) <- ((pRegExpr regex_'27'2b >>= withAttribute "Operator") >>~ (popContext >> return ()))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
