{- This module was generated from data in the Kate syntax highlighting file bibtex.xml, version 1.13,
   by  Jeroen Wijnhout (Jeroen.Wijnhout@kdemail.net) -}

module Text.Highlighting.Kate.Syntax.Bibtex ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "BibTeX"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.bib"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "BibTeX" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("BibTeX",["Normal"])], synStLanguage = "BibTeX", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return ()
    "Entry" -> return ()
    "String" -> return ()
    _ -> return ()
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents, synStCharsParsedInLine = 0, synStPrevChar = '\n' }

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Entry","kw"),("Command","fu"),("Field","dt"),("Ref Key","ot"),("String","st"),("Char","ch")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_kw'5fentry = Set.fromList $ words $ "@article @book @booklet @conference @inbook @incollection @inproceedings @manual @mastersthesis @misc @phdthesis @proceedings @techreport @unpublished @collection @patent"
list_kw'5fcommand = Set.fromList $ words $ "@string @preamble @comment"

regex_'28'5ba'2dzA'2dZ'5d'2b'29'5cs'2a'3d = compileRegex "([a-zA-Z]+)\\s*="
regex_'5c'5c'28'5ba'2dzA'2dZ'5d'2b'7c'2e'29 = compileRegex "\\\\([a-zA-Z]+|.)"

defaultAttributes = [("Normal","Normal Text"),("Entry","Ref Key"),("String","String")]

parseRules "Normal" = 
  do (attr, result) <- (((pFirstNonSpace >> pRegExpr regex_'28'5ba'2dzA'2dZ'5d'2b'29'5cs'2a'3d >>= withAttribute "Field"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~" list_kw'5fentry >>= withAttribute "Entry") >>~ pushContext "Entry")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~" list_kw'5fcommand >>= withAttribute "Command"))
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'5c'5c'28'5ba'2dzA'2dZ'5d'2b'7c'2e'29 >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String"))
     return (attr, result)

parseRules "Entry" = 
  do (attr, result) <- (((pDetectChar False ',' >>= withAttribute "Normal Text") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Normal Text"))
                        <|>
                        ((pRegExpr regex_'5c'5c'28'5ba'2dzA'2dZ'5d'2b'7c'2e'29 >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pRegExpr regex_'5c'5c'28'5ba'2dzA'2dZ'5d'2b'7c'2e'29 >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext >> return ())))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
