
//
// $Id: str.cc,v 1.8 2003/03/03 23:18:48 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/str.cc,v $
// $Revision: 1.8 $
// $Date: 2003/03/03 23:18:48 $
// $State: Exp $
//
// Author: Geoff Wong
//
/*
 * Some string support routines
 */
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <algorithm>

#include "str.h"

#define MAXTMP 256 

char * string_copy(const char * s)
{
	char * ret;
	ret = new char[strlen(s)+1];
	strcpy(ret,s);
	return ret;
}

/* 256 should be long enough for any integer we're printing! */
String itoa(int x)
{
	char tmp[MAXTMP];
	sprintf(tmp, "%d", x);
	String out(tmp);
	return out;
}

/* 256 should be long enough for any integer we're printing! */
String itodot(int x)
{
	/* assume that x is in network order. */
	char tmp[MAXTMP];
	int a,b,c,d;

	a = x & 0xff000000;
	b = x & 0x00ff0000;
	c = x & 0x0000ff00;
	d = x & 0x000000ff;

	sprintf(tmp, "%d.%d.%d.%d", a,b,c,d);
	String out(tmp);
	return out;
}

// itoa - same except pad it to a certain width with '0's.
String itoa(int x, int width, char pad)
{
	char tmp[MAXTMP];
	int i, l;

	if (width > MAXTMP) width = MAXTMP;

	sprintf(tmp, "%*d", width, x);

	l = strlen(tmp);
	for (i = 0; i < l; i++)
	{
		if (tmp[i] == ' ') tmp[i] = pad;
	}

	String out(tmp);
	return out;
}

String randomstr(int width)
{
    char tmp[width];
    memset(tmp, width, sizeof(char));

    String ret(tmp, width);

    for (int i = 0; i < width; i++)
    {
        ret[i] = (char)(random()%254 + 1);
    }
    return ret;
}

int split(String instr, String * outarr, int max, String sep)
{
    int i = -1, oldi = 0;
    int count = 0;
    int len = sep.length();
    int len2 = instr.length();
    String tmpcord;

    if (instr.empty() == true) return 0;

    while ( (oldi < len2) 
        && ((i = (int)instr.find(sep, oldi)) != -1) && (count < (max-1)))
    {
        tmpcord = instr.substr(oldi, i-(oldi));
        outarr[count] = tmpcord;
        count++;
        // outarr[count++] = instr.substr(oldi+1, i);
        oldi = i+len;
    }

    // urgh
    outarr[count++] =  instr.substr(oldi, instr.length());
    return count;
}

int gsub(String& str, const String& pat, const String& repl)
{
#ifdef OldFreeBSD
	return str.gsub(pat, repl);
#else
	int x = 0;
	int count = 0;

	while (x != -1)
	{
		x = str.find(pat, x+1);
		str.replace(x, pat.length(), repl);
		count++;
	}
	return count;
#endif
}


int reggsub(String& str, const String& regpat, const String& repl)
{
#ifdef OldFreeBSD
	Regex rstr = regpat.c_str();
	return str.gsub(rstr, repl);
#else
	int count = 0;
    int status;
	int len;
	int x = 0;
    regex_t   re;
	regmatch_t pmatch[1];
	const char * cstr;

    if (regcomp(&re, regpat.c_str(), REG_EXTENDED) != 0) 
	{
			/* report error? */
    		return(0);      
    }

	cstr = str.c_str();

	while (1)
	{
    	status = regexec(&re, &(cstr[x]), (size_t) 1, pmatch, 0);
    	if (status != 0) 
		{
    		break;
    	}
		if (pmatch[0].rm_so == -1) break;

		len = pmatch[0].rm_eo - pmatch[0].rm_so;
		str.replace(pmatch[0].rm_eo, len, repl);
		x = pmatch[0].rm_so + 1;
		count++;
	}

    regfree(&re);

    return count;
#endif
}

int regfind(const String& str, const String& pat)
{
    int status;
    regex_t   re;
	regmatch_t pmatch[1];
	const char * cstr;

    if (regcomp(&re, pat.c_str(), REG_EXTENDED) != 0) 
	{
			/* report error? */
    		return -1;      
    }

	cstr = str.c_str();
   	status = regexec(&re, cstr, (size_t) 1, pmatch, 0);
    if (status != 0) 
	{
   		return -1; 
    }

	return pmatch[0].rm_so;
}


string strip_whitespace(const string& str)
{
    string ret, whitespace = " \t\n";
    char * buf = (char *)malloc((str.length() + 1) * sizeof(char));
    unsigned int i, count = 0;

    for (i = 0; i < str.length(); i++)
    {
        if (str[i] != ' ' && str[i] != '\t' && str[i] != '\n')
            buf[count++] = str[i];
    }
    buf[count] = '\0';

    ret = buf;
    return ret;
}

string strip_trailing_whitespace(const string& str)
{
    int count;

    for (count = str.length()-1; count >= 0 && isspace(str[count]); count--)
        {};

    if (count < 0) return "";
    else return str.substr(0, count+1);
}

string topntail(const string& str)
{
    string ret, whitespace = " \t\n";
    char * buf = (char *)malloc((str.length() + 2) * sizeof(char));
    int i = 0, count = 0, start, end;

    while (str[i] == ' ' || str[i] == '\t' || str[i] == '\n') i++;
    start = i; 

    i = str.length() - 1;
    while (i >= 0 && (str[i] == ' ' || str[i] == '\t' || str[i] == '\n')) i--;
    end = i;

    for (i = start; i <= end; i++)
    {
        buf[count++] = str[i];
    }

    buf[count] = '\0';

    ret = buf;
    free(buf);
    return ret;
}

// Author: Zik Saleeba
string lowercase(const string& instr)
{
    string InStr = instr;
    transform(InStr.begin(), InStr.end(), InStr.begin(), tolower);
    return InStr;
}

#if 0
// Testing shit.
main()
{
	String x;

	x = itoa(7,2, ' ');

    printf("random:#%s#\n", randomstr(20).c_str());
}
#endif
