
//
// A File Reader 
//
// Provides support for reading in conf/script files.
// 
// $Id: reader.h,v 1.1.1.1 2000/11/29 13:20:15 dredd Exp $
// 
// $Source: /cvsroot/hammerhead/hammerhead/src/reader.h,v $
// $Revision: 1.1.1.1 $
// $Date: 2000/11/29 13:20:15 $
// $State: Exp $
// $Log: reader.h,v $
// Revision 1.1.1.1  2000/11/29 13:20:15  dredd
//
//
// Initial hammerhead 2 import for sourceforge.
//
//
// Revision 1.1  2000/10/13 06:33:23  geoff
//
//
// Another support class.
//
//
// Author: Geoff Wong
// Copyright (C) 1999.
// Zikzak Tech Standard Library Code.
//
// Notes:
//      Reader objects should be created 1 per file pointer.
//      Should be destructed when finished.
//


#ifndef READER_H
#define READER_H

#include <stdio.h>
#include "String.h"

const String DEFAULT_WHITESPACE = " \t\n";
const String DEFAULT_EOL = "\n";
const char DEFAULT_COMMENT = '#';
const int MAX_LINE = 1024;

class Reader
{
    char comment;
        // comments are ignored to EOL.

    String whitespace;
        // whitespace chars.

    bool _eof;
        // end of file reached? 

    FILE * fp;
        // current file we're working on.

    void skip_whitespace();
        // skips along past any whitespace.
        //
    void skip_comment();
        // skips along past a comment (eol terminated)

public:
    Reader(const String& filename);
    virtual ~Reader();

    String get_line();
        // Purpose: just get a line of a file
        
    String get_script_line();
        // Purpose: just get a "clean" script line from the file
        //      Leading whitespace is trimmed, comments trimmed too.

    String get_word();
    bool eof();
};

#endif
