/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "splinepoint.h"

SplinePoint::SplinePoint()
 : SortablePoint()
{
    order=HORIZONTAL;
    size=7;
    cpSize=3;
    selectedVar=FALSE;
    cp1.setX(0);
    cp1.setY(0);
    cp1.rx()-=30;
    cp1.setSize(cpSize);
    cp2.setX(0);
    cp2.setY(0);
    cp2.rx()+=30;
    cp2.setSize(cpSize);
}

SplinePoint::SplinePoint(QPoint p)
    : SortablePoint(p)
{
    order=HORIZONTAL;
    size=7;
    cpSize=3;
    selectedVar=FALSE;
    cp1.setSize(cpSize);
    cp2.setSize(cpSize);
}

SplinePoint::SplinePoint(QPoint p,QPoint _cp1,QPoint _cp2)
    : SortablePoint(p)
{
    order=HORIZONTAL;
    size=7;
    cpSize=3;
    selectedVar=FALSE;
    cp1=_cp1;
    cp2=_cp2;
}


SplinePoint::~SplinePoint()
{
}

