/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
#include <math.h>


void FFTDialogBase::setDefault()
{
    bm_range->setRangeMinValue(0);
    bm_range->setRangeMaxValue(22000);
    bm_range->setMaxValue(22000);
    bm_range->setMinValue(100);

    
    s_range->setRangeMinValue(0);
    s_range->setRangeMaxValue(22000);
    s_range->setMaxValue(22000);
    s_range->setMinValue(100);
    
    
    bm_width_slider->setValue(10);
    bm_adv_slider->setValue(8);
    bm_nbb_slider->setValue(7);
    
    s_width_slider->setValue(12);
    s_adv_slider->setValue(9);
    s_nbb_slider->setValue(9);
    
    hanning_window->setChecked(true);
    
    bm_pad_zero->setChecked(true);
    s_pad_zero->setChecked(true);
    
    normalize->setChecked(true);
    
    bm_bark->setChecked(false);
    s_bark->setChecked(false);
    bm_bark_slider->setValue(10);
    bm_bark_slider->setEnabled(FALSE);
    s_bark_slider->setValue(10);
    s_bark_slider->setEnabled(FALSE);
    
    
}


void FFTDialogBase::BmWidthChanged( int )
{
    bm_adv_slider->setMaxValue(bm_width_slider->value());
    bm_nbb_slider->setMaxValue(
	    getMaxNbBands(bm_range->minValue(),
			      bm_range->maxValue(),
			      bm_width_slider->value()));

}


void FFTDialogBase::SWidthChanged( int )
{
    s_adv_slider->setMaxValue(s_width_slider->value());
    s_nbb_slider->setMaxValue(
	    getMaxNbBands(s_range->minValue(),
			      s_range->maxValue(),
			      s_width_slider->value()));
}

void FFTDialogBase::BmStartFreqChanged( int )
{

    bm_nbb_slider->setMaxValue(
	   	    getMaxNbBands(bm_range->minValue(),
			      bm_range->maxValue(),
			      bm_width_slider->value()));

}

void FFTDialogBase::BmEndFreqChanged( int )
{

    bm_nbb_slider->setMaxValue(
	    getMaxNbBands(bm_range->minValue(),
			      bm_range->maxValue(),
			      bm_width_slider->value()));
}

void FFTDialogBase::SStartFreqChanged( int )
{

    s_nbb_slider->setMaxValue(
	     getMaxNbBands(s_range->minValue(),
			      s_range->maxValue(),
			      s_width_slider->value()));
}

void FFTDialogBase::SEndFreqChanged( int )
{

    s_nbb_slider->setMaxValue(
	     getMaxNbBands(s_range->minValue(),
			      s_range->maxValue(),
			      s_width_slider->value()));
}


void FFTDialogBase::copyBMToSP()
{
    if(linkToBM->isChecked()){
	s_adv_slider->setMaxValue(bm_adv_slider->maxValue());
	s_adv_slider->setValue(bm_adv_slider->value());
	
	s_nbb_slider->setMaxValue(bm_nbb_slider->maxValue());
	s_nbb_slider->setValue(bm_nbb_slider->value());
	
	s_width_slider->setMaxValue(bm_width_slider->maxValue());
	s_width_slider->setValue(bm_width_slider->value());
	
	s_range->setMinValue(bm_range->minValue());	
	s_range->setMaxValue(bm_range->maxValue());

	
	
	if(bm_pad_zero->isChecked())
	    s_pad_zero->setChecked(TRUE);
	else s_pad_signal->setChecked(TRUE);
	
	s_bark->setChecked(bm_bark->isChecked());
	s_bark_slider->setValue(bm_bark_slider->value());
	
	
	
    }else{
    }
    
}


int FFTDialogBase::getMaxNbBands(int startfreq, int endfreq, int width){
    float start_index=(startfreq*pow(2,width))/44100;
    float end_index=(endfreq*pow(2,width))/44100;
    int maxvalue=int(floor(log2(end_index-start_index)));
    return maxvalue<4?4:maxvalue;
}


void FFTDialogBase::BmBarkToggled( bool )
{

}


void FFTDialogBase::SBarkToggled( bool )
{

}
