/*
 * Decompiled with CFR 0.152.
 */
package fix;

import fix.ErrorWindow;
import fix.NaiveTrustManager;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HttpClient {
    private Socket socket = null;
    private String NEWLINE = "\r\n";
    public DataOutputStream out = null;
    private ErrorWindow er = null;
    private static boolean error = false;
    private static SSLSocketFactory sslSocketFactory = null;
    private boolean debug = false;

    public HttpClient(ErrorWindow errorWindow, boolean bl) {
        this.debug = bl;
        this.er = errorWindow;
    }

    public void connect(String string) {
        String[] stringArray = this.parseURL(string);
        int n = Integer.parseInt(stringArray[2]);
        if (stringArray[0].startsWith("https")) {
            this.httpsConnect(stringArray[1], n);
        } else if (stringArray[0].startsWith("http")) {
            this.httpConnect(stringArray[1], n);
        } else {
            this.er.setMess("Wrong protocol: Please use HTTP or HTTPS.", null);
        }
        try {
            this.out = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.er.setMess("No Connection to Server.", iOException);
        }
    }

    public void httpConnect(String string, int n) {
        try {
            this.socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            this.er.setMess("Host-Server is unknown.", unknownHostException);
        }
        catch (IOException iOException) {
            this.er.setMess("Could not connect to HTTP-Server: " + iOException.getMessage(), iOException);
        }
    }

    public void httpsConnect(String string, int n) {
        try {
            this.socket = this.getSocketFactory().createSocket(string, n);
        }
        catch (IOException iOException) {
            this.er.setMess("Could not connect to HTTPS-Server.", iOException);
        }
    }

    public void send(String string) {
        block2: {
            try {
                this.out.writeBytes(string);
                System.out.print(string);
            }
            catch (IOException iOException) {
                if (error) break block2;
                this.er.setMess("Error while sending header: " + iOException.getMessage(), iOException);
                error = true;
            }
        }
    }

    public void send(byte[] byArray) {
        block4: {
            try {
                this.out.write(byArray);
                if (this.debug) {
                    for (byte by : byArray) {
                        System.out.print((char)by);
                    }
                }
            }
            catch (IOException iOException) {
                if (error) break block4;
                this.er.setMess("Error while sending header: " + iOException.getMessage(), iOException);
                error = true;
            }
        }
    }

    public void nl() {
        this.send(this.NEWLINE);
    }

    public String[] parseURL(String string) {
        String[] stringArray = new String[4];
        try {
            URL uRL = new URL(string);
            stringArray[0] = uRL.getProtocol();
            stringArray[1] = uRL.getHost();
            stringArray[2] = "" + uRL.getPort();
            stringArray[3] = uRL.getFile();
            if (!stringArray[0].equals("http") && !stringArray[0].equals("https")) {
                throw new IllegalArgumentException("Protocol must be http or https.");
            }
            if (Integer.parseInt(stringArray[2]) == -1) {
                stringArray[2] = "" + this.getPort(stringArray[0]);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.er.setMess("Malformed Server URL: " + string, malformedURLException);
        }
        return stringArray;
    }

    public int getPort(String string) {
        if (string.equals("https")) {
            return 443;
        }
        return 80;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public final SSLSocketFactory getSocketFactory() {
        if (sslSocketFactory == null) {
            try {
                TrustManager[] trustManagerArray = new TrustManager[]{new NaiveTrustManager()};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(new KeyManager[0], trustManagerArray, new SecureRandom());
                sslSocketFactory = sSLContext.getSocketFactory();
            }
            catch (KeyManagementException keyManagementException) {
                this.er.setMess("No SSL algorithm support: ", keyManagementException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.er.setMess("Exception when setting up the Naive key management.", noSuchAlgorithmException);
            }
        }
        return sslSocketFactory;
    }
}

