/* $Id: log.h 4768 2009-09-29 13:56:58Z potyra $
 *
 *  Utilitiy functions to log assertions messages.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LOG_H_INCLUDED
#define __LOG_H_INCLUDED

#include "fauhdli.h"

/** log a character to stdout.
 *  @param callbacks callbacks for logging/scheduler access.
 *  @param level -1 continue message, 0: note, 1: warning, 2: error,
 *         3: failure.
 *  @param path_name path to instance which requested logging
 *         (usually the stack name).
 *  @param c character to log.
 */
extern void
log_vhdl(
	const struct glue_vhdl_cb *callbacks, 
	int level, 
	const char *path_name, 
	char c
);

#endif /* __LOG_H_INCLUDED */
