/* $Id: RegisterFactory.cpp 4502 2009-04-21 16:00:59Z potyra $ 
 *
 * RegisterFactory: create and keep track of virtual registers.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "intermediate/operands/RegisterFactory.hpp"
#include "intermediate/operands/Register.hpp"

namespace intermediate {

Register *
RegisterFactory::getReg(enum OpType type)
{
	Register *ret = new Register(type, this->cnt);
	this->cnt++;
	return ret;
}

unsigned int
RegisterFactory::getNumUsedRegs(void) const
{
	return this->cnt;
}

}; /* namespace intermediate */
