/***************************************************************************
                          FLTableMetaData.cpp  -  description
                             -------------------
    begin                : Mon Jul 2 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLTableMetaData.h"
#include "FLFieldMetaData.h"
#include "FLRelationMetaData.h"
#include "FLCompoundKey.h"

FLTableMetaData::FLTableMetaData (const QString & n, const QString & a, const QString & f):
name_ (n.lower ()),
alias_ (a),
fieldList_ (0),
compoundKeyList_ (0)
{
  pathFormRecord_ = QString (FLDATA) + "/facturalux/forms/" + f;
}

FLTableMetaData::~FLTableMetaData ()
{
  if (fieldList_)
	{
	  fieldList_->clear ();
	  delete fieldList_;
	}

  if (compoundKeyList_)
	{
	  compoundKeyList_->clear ();
	  delete compoundKeyList_;
	}
}

void
FLTableMetaData::addFieldMD (const FLFieldMetaData * f)
{
  if (!fieldList_)
	{
	  fieldList_ = new FLFieldMetaDataList;
	  fieldList_->setAutoDelete (true);
	}

  if (f)
	fieldList_->append (f);
}

void
FLTableMetaData::setFieldList (FLFieldMetaDataList * fl)
{
  if (!fl)
	return;

  if (fl->isEmpty ())
	return;

  if (fieldList_)
	{
	  fieldList_->clear ();
	  delete fieldList_;
	}
  fieldList_ = fl;
}

void
FLTableMetaData::setCompoundKeyList (FLCompoundKeyList * cl)
{
  if (!cl)
	return;

  if (cl->isEmpty ())
	return;

  if (compoundKeyList_)
	{
	  compoundKeyList_->clear ();
	  delete compoundKeyList_;
	}
  compoundKeyList_ = cl;
}

void
FLTableMetaData::addCompoundKey (const FLCompoundKey * cK)
{
  if (!compoundKeyList_)
	{
	  compoundKeyList_ = new FLCompoundKeyList;
	  compoundKeyList_->setAutoDelete (true);
	}

  if (cK)
	compoundKeyList_->append (cK);
}

const QString
FLTableMetaData::fieldNameToAlias (const QString & fN)
{
  if (!fieldList_)
	return fN;

  if (fieldList_->isEmpty ())
	return fN;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->alias ();
	}

  return fN;
}

const QString
FLTableMetaData::fieldAliasToName (const QString & aN)
{
  if (!fieldList_)
	return aN;

  if (fieldList_->isEmpty ())
	return aN;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->alias ().lower () == aN.lower ())
		return field->name ();
	}

  return aN;
}

const int
FLTableMetaData::fieldType (const QString & fN)
{
  if (!fieldList_)
	return QVariant::Invalid;

  if (fieldList_->isEmpty ())
	return QVariant::Invalid;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->type ();
	}

  return QVariant::Invalid;
}

const int
FLTableMetaData::fieldLength (const QString & fN)
{
  if (!fieldList_)
	return 0;

  if (fieldList_->isEmpty ())
	return 0;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->length ();
	}

  return 0;
}

const int
FLTableMetaData::fieldPartInteger (const QString & fN)
{
  if (!fieldList_)
	return 0;

  if (fieldList_->isEmpty ())
	return 0;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->partInteger ();
	}

  return 0;
}

const int
FLTableMetaData::fieldPartDecimal (const QString & fN)
{
  if (!fieldList_)
	return 0;

  if (fieldList_->isEmpty ())
	return 0;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->partDecimal ();
	}

  return 0;
}

const bool
FLTableMetaData::fieldIsPrimaryKey (const QString & fN)
{
  if (!fieldList_)
	return false;

  if (fieldList_->isEmpty ())
	return false;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->isPrimaryKey ();
	}

  return false;
}

const QString
FLTableMetaData::primaryKey ()
{
  if (!fieldList_)
	return QString::null;

  if (fieldList_->isEmpty ())
	return QString::null;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->isPrimaryKey ())
		return field->name ();
	}

  return QString::null;
}

const bool
FLTableMetaData::fieldIsIndex (const QString & fN)
{
  if (!fieldList_)
	return false;

  if (fieldList_->isEmpty ())
	return false;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->isIndex ();
	}

  return false;
}

const bool
FLTableMetaData::fieldIsUnique (const QString & fN)
{
  if (!fieldList_)
	return false;

  if (fieldList_->isEmpty ())
	return false;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->isUnique ();
	}

  return false;
}

/* Funcin aadida por Andrs Otn Urbano (baxas@eresmas.com) */
const bool
FLTableMetaData::fieldIsCounter (const QString & fN)
{
  if (!fieldList_)
	return false;

  if (fieldList_->isEmpty ())
	return false;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->isCounter ();
	}

  return false;
}

const bool
FLTableMetaData::fieldCalculated (const QString & fN)
{
  if (!fieldList_)
	return false;

  if (fieldList_->isEmpty ())
	return false;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->calculated ();
	}

  return false;
}

const bool
FLTableMetaData::fieldVisible (const QString & fN)
{
  if (!fieldList_)
	return false;

  if (fieldList_->isEmpty ())
	return false;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field->visible ();
	}

  return false;
}

FLFieldMetaData *
FLTableMetaData::field (const QString & fN)
{
  if (!fieldList_)
	return 0;

  if (fieldList_->isEmpty ())
	return 0;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		return field;
	}

  return 0;
}

const QString
FLTableMetaData::fieldTableM1 (const QString & fN)
{
  if (!fieldList_)
	return QString::null;

  if (fieldList_->isEmpty ())
	return QString::null;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		{
		  if (field->relationM1 ())
			return field->relationM1 ()->foreignTable ();
		}
	}

  return QString::null;
}

const QString
FLTableMetaData::fieldForeignFieldM1 (const QString & fN)
{
  if (!fieldList_)
	return QString::null;

  if (fieldList_->isEmpty ())
	return QString::null;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		{
		  if (field->relationM1 ())
			return field->relationM1 ()->foreignField ();
		}
	}

  return QString::null;
}

FLRelationMetaData *
FLTableMetaData::relation (const QString & fN, const QString & fFN)
{
  if (!fieldList_)
	return 0;

  if (fieldList_->isEmpty ())
	return 0;

  FLFieldMetaData *field;

  for (unsigned int i = 0; i < fieldList_->count (); i++)
	{
	  field = fieldList_->at (i);
	  if (field->name () == fN.lower ())
		{
		  if (field->relationM1 ())
			if (field->relationM1 ()->foreignField () == fFN.lower ())
			  return field->relationM1 ();

		  FLFieldMetaData::FLRelationMetaDataList * relationList = field->relationList ();

		  if (!relationList)
			return 0;

		  if (relationList->isEmpty ())
			return 0;

		  FLRelationMetaData *r;

		  for (unsigned int j = 0; j < relationList->count (); j++)
			{
			  r = relationList->at (j);
			  if (r->foreignField () == fFN.lower ())
				return r;
			}
		}
	}

  return 0;
}

FLTableMetaData::FLFieldMetaDataList * FLTableMetaData::fieldListOfCompoundKey (const QString & fN)
{
  if (!compoundKeyList_)
	return 0;

  if (compoundKeyList_->isEmpty ())
	return 0;

  FLCompoundKey *
	cK;

  for (unsigned int i = 0; i < compoundKeyList_->count (); i++)
	{
	  cK = compoundKeyList_->at (i);
	  if (cK->hasField (fN))
		return cK->fieldList ();
	}

  return 0;
}
